/*
 * Decompiled with CFR 0.152.
 */
package com.taxonic.carml.model.impl;

import com.taxonic.carml.model.Join;
import com.taxonic.carml.model.RefObjectMap;
import com.taxonic.carml.model.TriplesMap;
import com.taxonic.carml.model.impl.JoinImpl;
import com.taxonic.carml.model.impl.TriplesMapImpl;
import com.taxonic.carml.rdf_mapper.annotations.RdfProperty;
import com.taxonic.carml.rdf_mapper.annotations.RdfType;
import java.util.LinkedHashSet;
import java.util.Set;

public class RefObjectMapImpl
implements RefObjectMap {
    private TriplesMap parentTriplesMap;
    private Set<Join> joinConditions;

    public RefObjectMapImpl() {
    }

    public RefObjectMapImpl(TriplesMap parentTriplesMap, Set<Join> joinConditions) {
        this.parentTriplesMap = parentTriplesMap;
        this.joinConditions = joinConditions;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#parentTriplesMap")
    @RdfType(value=TriplesMapImpl.class)
    public TriplesMap getParentTriplesMap() {
        return this.parentTriplesMap;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#joinCondition")
    @RdfType(value=JoinImpl.class)
    public Set<Join> getJoinConditions() {
        return this.joinConditions;
    }

    public void setParentTriplesMap(TriplesMap parentTriplesMap) {
        this.parentTriplesMap = parentTriplesMap;
    }

    public void setJoinConditions(Set<Join> joinConditions) {
        this.joinConditions = joinConditions;
    }

    public String toString() {
        return "RefObjectMapImpl [getParentTriplesMap()=" + this.getParentTriplesMap() + ", getJoinConditions()=" + this.getJoinConditions() + "] ";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.joinConditions == null ? 0 : this.joinConditions.hashCode());
        result = 31 * result + (this.parentTriplesMap == null ? 0 : this.parentTriplesMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RefObjectMapImpl other = (RefObjectMapImpl)obj;
        if (this.joinConditions == null ? other.joinConditions != null : !this.joinConditions.equals(other.joinConditions)) {
            return false;
        }
        return !(this.parentTriplesMap == null ? other.parentTriplesMap != null : !this.parentTriplesMap.equals(other.parentTriplesMap));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private TriplesMap parentTriplesMap;
        private Set<Join> joinConditions = new LinkedHashSet<Join>();

        Builder() {
        }

        public Builder parentTriplesMap(TriplesMap parentTriplesMap) {
            this.parentTriplesMap = parentTriplesMap;
            return this;
        }

        public Builder joinConditions(Set<Join> joinConditions) {
            this.joinConditions = joinConditions;
            return this;
        }

        public Builder condition(Join condition) {
            this.joinConditions.add(condition);
            return this;
        }

        public RefObjectMapImpl build() {
            return new RefObjectMapImpl(this.parentTriplesMap, this.joinConditions);
        }
    }
}

