/*
 * Decompiled with CFR 0.152.
 */
package com.taxjar.net;

import com.taxjar.exception.ApiConnectionException;
import com.taxjar.exception.TaxjarException;
import com.taxjar.net.Listener;
import java.io.IOException;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ApiCallback<T>
implements Callback<T> {
    protected Listener<T> apiListener;

    public ApiCallback(Listener<T> listener) {
        this.apiListener = listener;
    }

    public void onResponse(Call<T> call, Response<T> response) {
        if (response.isSuccessful()) {
            this.apiListener.onSuccess(response.body());
        } else {
            try {
                this.apiListener.onError(new TaxjarException(response.errorBody().string()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void onFailure(Call<T> call, Throwable t) {
        this.apiListener.onError(new ApiConnectionException(t.getMessage(), t));
    }
}

