/*
 * Decompiled with CFR 0.152.
 */
package com.julienvey.trello.impl.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.julienvey.trello.NotAuthorizedException;
import com.julienvey.trello.NotFoundException;
import com.julienvey.trello.TrelloBadRequestException;
import com.julienvey.trello.TrelloHttpClient;
import com.julienvey.trello.exception.TrelloHttpException;
import com.julienvey.trello.impl.TrelloImpl;
import com.julienvey.trello.impl.http.UrlExpander;
import com.julienvey.trello.utils.IOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDKTrelloHttpClient
implements TrelloHttpClient {
    private static final Logger log = LoggerFactory.getLogger(TrelloImpl.class);
    private static final String APPLICATION_JSON = "application/json;charset=utf-8";
    private static final String LF = "\r\n";
    private static final String GZIP = "gzip";
    private final ObjectMapper objectMapper;

    public JDKTrelloHttpClient(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    public JDKTrelloHttpClient() {
        this(new ObjectMapper());
    }

    @Override
    public <T> T get(String url, Class<T> responseType, String ... params) {
        try {
            HttpURLConnection conn = this.openConnection(url, params, "GET");
            return this.readResponse(responseType, conn);
        }
        catch (IOException e) {
            throw new TrelloHttpException(e);
        }
    }

    @Override
    public <T> T postForObject(String url, Object body, Class<T> responseType, String ... params) {
        try {
            HttpURLConnection conn = this.openConnection(url, params, "POST");
            this.writeRequest(body, conn);
            return this.readResponse(responseType, conn);
        }
        catch (IOException e) {
            throw new TrelloHttpException(e);
        }
    }

    @Override
    public URI postForLocation(String url, Object body, String ... params) {
        try {
            HttpURLConnection conn = this.openConnection(url, params, "POST");
            this.writeRequest(body, conn);
            String location = Optional.ofNullable(conn.getHeaderField("Location")).orElseThrow(() -> new NullPointerException("Location header is not present!"));
            return URI.create(location);
        }
        catch (IOException e) {
            throw new TrelloHttpException(e);
        }
    }

    private HttpURLConnection openConnection(String url, String[] params, String httpMethod) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(UrlExpander.expandUrl(url, params)).openConnection();
        conn.setRequestProperty("Accept", APPLICATION_JSON);
        conn.setRequestProperty("Content-Type", APPLICATION_JSON);
        conn.setRequestProperty("Accept-Encoding", GZIP);
        conn.setRequestMethod(httpMethod);
        if (httpMethod.equals("POST") || httpMethod.equals("PUT")) {
            conn.setDoOutput(true);
        }
        return conn;
    }

    @Override
    public <T> T putForObject(String url, Object body, Class<T> responseType, String ... params) {
        try {
            HttpURLConnection conn = this.openConnection(url, params, "PUT");
            this.writeRequest(body, conn);
            return this.readResponse(responseType, conn);
        }
        catch (IOException e) {
            throw new TrelloHttpException(e);
        }
    }

    @Override
    public <T> T delete(String url, Class<T> responseType, String ... params) {
        try {
            HttpURLConnection conn = this.openConnection(url, params, "DELETE");
            return this.readResponse(responseType, conn);
        }
        catch (IOException e) {
            throw new TrelloHttpException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T postFileForObject(String url, File file, Class<T> responseType, String ... params) {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            HttpURLConnection conn = this.openConnection(url, params, "POST");
            String boundary = "----" + UUID.randomUUID();
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            try (OutputStream requestStream = conn.getOutputStream();
                 OutputStreamWriter writer = new OutputStreamWriter(requestStream);){
                ((Writer)writer).append(LF).append("--").append(boundary).append(LF).append("Content-Disposition: form-data; name=\"file\"; filename=\"" + file.getName() + "\"").append(LF).append("Content-Type: application/octet-stream").append(LF).append("Content-Transfer-Encoding: binary").append(LF).append(LF);
                ((Writer)writer).flush();
                IOUtils.copyTo(in, requestStream);
                ((Writer)writer).append(LF).append("--").append(boundary).append("--").append(LF).flush();
            }
            T t = this.readResponse(responseType, conn);
            return t;
        }
        catch (IOException e) {
            throw new TrelloHttpException(e);
        }
    }

    private void checkStatusCode(HttpURLConnection conn) throws IOException {
        switch (conn.getResponseCode()) {
            case 400: {
                throw new TrelloBadRequestException(IOUtils.toString(conn.getErrorStream()));
            }
            case 401: {
                throw new NotAuthorizedException();
            }
            case 404: {
                throw new NotFoundException("Resource not found: " + conn.getURL());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T readResponse(Class<T> responseType, HttpURLConnection conn) throws IOException {
        this.checkStatusCode(conn);
        try (InputStream responseStream = this.responseStream(conn);){
            Object object = this.objectMapper.readValue(responseStream, responseType);
            return (T)object;
        }
        catch (JsonProcessingException e) {
            throw new TrelloHttpException("Cannot parse Trello response. Expected to get a json string, but got: " + IOUtils.toString(this.responseStream(conn)));
        }
    }

    private InputStream responseStream(HttpURLConnection conn) throws IOException {
        boolean isCompressed = GZIP.equalsIgnoreCase(conn.getHeaderField("Content-Encoding"));
        if (isCompressed) {
            log.debug("Using GZIPInputStream for {}", (Object)conn.getURL());
            return new GZIPInputStream(conn.getInputStream());
        }
        return conn.getInputStream();
    }

    private void writeRequest(Object object, HttpURLConnection conn) throws IOException {
        try (OutputStream requestStream = conn.getOutputStream();){
            this.objectMapper.writeValue(requestStream, object);
        }
    }
}

