/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2;

import android.support.annotation.NonNull;
import android.support.annotation.Size;
import com.taptrack.tcmptappy2.AbstractTCMPMessage;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.MessageGarbledException;
import com.taptrack.tcmptappy2.TCMPMessageParseException;
import com.taptrack.tcmptappy2.TCMPUtils;

public class RawTCMPMessage
extends AbstractTCMPMessage {
    protected byte[] payload;
    protected byte[] commandFamily;
    protected byte commandCode;

    public RawTCMPMessage(@NonNull byte[] message) throws TCMPMessageParseException {
        try {
            if (TCMPUtils.validate(message)) {
                this.commandFamily = new byte[]{message[3], message[4]};
                this.commandCode = message[5];
                int length = message.length - 8;
                this.payload = new byte[length];
                System.arraycopy(message, 6, this.payload, 0, length);
            }
        }
        catch (MessageGarbledException | IllegalArgumentException e) {
            e.printStackTrace();
            throw new TCMPMessageParseException("Unable to parse, invalid format", e);
        }
    }

    @Override
    public void parsePayload(@NonNull byte[] payload) throws MalformedPayloadException {
        this.payload = payload;
    }

    @Override
    @NonNull
    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    public byte getCommandCode() {
        return this.commandCode;
    }

    @Override
    @NonNull
    @Size(value=2L)
    public byte[] getCommandFamily() {
        return this.commandFamily;
    }
}

