/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taptrack.tcmptappy2.CommandFamilyMessageResolver;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.MessageResolver;
import com.taptrack.tcmptappy2.TCMPMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageResolverMux
implements MessageResolver {
    private final Map<CommandFamilyIdKey, MessageResolver> familyResolverMap;
    private final List<MessageResolver> otherResolverList;

    public MessageResolverMux(MessageResolver ... resolvers) {
        HashMap<CommandFamilyIdKey, MessageResolver> resolverMap = null;
        ArrayList<MessageResolver> otherResolverList = null;
        for (MessageResolver resolver : resolvers) {
            if (resolver instanceof CommandFamilyMessageResolver) {
                if (resolverMap == null) {
                    resolverMap = new HashMap<CommandFamilyIdKey, MessageResolver>(1);
                }
                resolverMap.put(new CommandFamilyIdKey(((CommandFamilyMessageResolver)resolver).getCommandFamilyId()), resolver);
                continue;
            }
            if (otherResolverList == null) {
                otherResolverList = new ArrayList<MessageResolver>(1);
            }
            otherResolverList.add(resolver);
        }
        this.familyResolverMap = resolverMap != null ? resolverMap : Collections.emptyMap();
        this.otherResolverList = otherResolverList != null ? otherResolverList : Collections.emptyList();
    }

    @Override
    @Nullable
    public TCMPMessage resolveCommand(@NonNull TCMPMessage message) throws MalformedPayloadException {
        TCMPMessage result;
        CommandFamilyIdKey key = new CommandFamilyIdKey(message.getCommandFamily());
        MessageResolver familyResolver = this.familyResolverMap.get(key);
        if (familyResolver != null && (result = familyResolver.resolveCommand(message)) != null) {
            return result;
        }
        for (MessageResolver resolver : this.otherResolverList) {
            TCMPMessage result2 = resolver.resolveCommand(message);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Override
    @Nullable
    public TCMPMessage resolveResponse(@NonNull TCMPMessage message) throws MalformedPayloadException {
        TCMPMessage result;
        CommandFamilyIdKey key = new CommandFamilyIdKey(message.getCommandFamily());
        MessageResolver familyResolver = this.familyResolverMap.get(key);
        if (familyResolver != null && (result = familyResolver.resolveResponse(message)) != null) {
            return result;
        }
        for (MessageResolver resolver : this.otherResolverList) {
            TCMPMessage result2 = resolver.resolveResponse(message);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    private static class CommandFamilyIdKey {
        private final byte[] familyId;

        private CommandFamilyIdKey(byte[] familyId) {
            this.familyId = familyId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CommandFamilyIdKey that = (CommandFamilyIdKey)o;
            return Arrays.equals(this.familyId, that.familyId);
        }

        public int hashCode() {
            return Arrays.hashCode(this.familyId);
        }
    }
}

