/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2;

import com.taptrack.tcmptappy2.MessageGarbledException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

class TCMPUtils {
    TCMPUtils() {
    }

    static byte[] calculateCRCBitwise(byte[] data) {
        int crc = 25443;
        for (int i = 0; i < data.length; ++i) {
            crc = TCMPUtils.update_cr16(crc, data[i]);
        }
        return TCMPUtils.shortToByteArray((short)crc);
    }

    private static int update_cr16(int crc, byte b) {
        int tcrc = 0;
        int v = (crc ^ b) & 0xFF;
        for (int i = 0; i < 8; ++i) {
            tcrc = ((tcrc ^ v) & 1) != 0 ? tcrc >> 1 ^ 0x8408 : tcrc >> 1;
            v >>= 1;
        }
        return (crc >> 8 ^ tcrc) & 0xFFFF;
    }

    private static byte[] shortToByteArray(short value) {
        return new byte[]{(byte)(value >>> 8), (byte)value};
    }

    static byte[] concatByteArr(byte[] ... byteArrays) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (byte[] byteArray : byteArrays) {
            stream.write(byteArray);
        }
        return stream.toByteArray();
    }

    public static boolean validate(byte[] data) throws IllegalArgumentException, MessageGarbledException {
        if (data.length >= 8) {
            byte l1 = data[0];
            byte l2 = data[1];
            byte lcs = data[2];
            byte[] family = new byte[]{data[3], data[4]};
            byte command = data[5];
            byte[] crc = new byte[]{data[data.length - 2], data[data.length - 1]};
            byte[] toCheckCRC = Arrays.copyOfRange(data, 0, data.length - 2);
            byte[] toCheckLength = Arrays.copyOfRange(data, 3, data.length);
            byte[] calculatedCRC = TCMPUtils.calculateCRCBitwise(toCheckCRC);
            byte calculatedLcs = (byte)(-1 - ((l1 & 0xFF) + (l2 & 0xFF) & 0xFF) + 1 & 0xFF);
            if (calculatedLcs == lcs && Arrays.equals(crc, calculatedCRC)) {
                int expectedLength = ((l1 & 0xFF) << 8) + (l2 & 0xFF);
                if (expectedLength == toCheckLength.length) {
                    return true;
                }
                throw new IllegalArgumentException("Body of command too short");
            }
            throw new MessageGarbledException("Bad CRC or LCS");
        }
        throw new IllegalArgumentException("Command too short");
    }
}

