/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2;

import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.StandardErrorResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class StandardErrorResponseDelegate
implements StandardErrorResponse {
    private byte errorCode;
    private byte internalErrorCode;
    private byte readerStatus;
    private String errorMessage;

    public StandardErrorResponseDelegate() {
        this.errorCode = 0;
        this.internalErrorCode = 0;
        this.readerStatus = 0;
        this.errorMessage = "";
    }

    public StandardErrorResponseDelegate(byte errorCode, byte internalErrorCode, byte readerStatus, String errorMessage) {
        this.errorCode = errorCode;
        this.internalErrorCode = internalErrorCode;
        this.readerStatus = readerStatus;
        this.errorMessage = errorMessage;
    }

    public StandardErrorResponseDelegate(byte errorCode, byte internalErrorCode, byte readerStatus, byte[] errorMessage) {
        this(errorCode, internalErrorCode, readerStatus, new String(errorMessage));
    }

    @Override
    public byte getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void setErrorCode(byte errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public byte getInternalErrorCode() {
        return this.internalErrorCode;
    }

    @Override
    public void setInternalErrorCode(byte internalErrorCode) {
        this.internalErrorCode = internalErrorCode;
    }

    @Override
    public byte getReaderStatus() {
        return this.readerStatus;
    }

    @Override
    public void setReaderStatus(byte readerStatus) {
        this.readerStatus = readerStatus;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public void setErrorMessage(byte[] errorMessage) {
        this.errorMessage = new String(errorMessage);
    }

    @Override
    public void parsePayload(byte[] payload) throws MalformedPayloadException {
        if (payload.length >= 3) {
            this.errorCode = (byte)(payload[0] & 0xFF);
            this.internalErrorCode = (byte)(payload[1] & 0xFF);
            this.readerStatus = (byte)(payload[2] & 0xFF);
            if (payload.length > 3) {
                byte[] message = Arrays.copyOfRange(payload, 3, payload.length);
                this.errorMessage = new String(message);
            } else {
                this.errorMessage = "";
            }
        } else {
            throw new MalformedPayloadException("Payload too short");
        }
    }

    @Override
    public byte[] getPayload() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(3 + this.errorMessage.length());
        outputStream.write(this.errorCode);
        outputStream.write(this.internalErrorCode);
        outputStream.write(this.readerStatus);
        try {
            outputStream.write(this.errorMessage.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] payload = outputStream.toByteArray();
        try {
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return payload;
    }
}

