/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2;

import android.support.annotation.NonNull;
import com.taptrack.tcmptappy2.TCMPMessage;
import com.taptrack.tcmptappy2.TCMPUtils;
import java.io.IOException;

public abstract class AbstractTCMPMessage
implements TCMPMessage {
    @Override
    @NonNull
    public byte[] toByteArray() {
        byte[] data = this.getPayload();
        byte[] family = this.getCommandFamily();
        byte code = this.getCommandCode();
        int length = data.length + 5;
        byte l1 = (byte)(length >> 8 & 0xFF);
        byte l2 = (byte)(length & 0xFF);
        byte lcs = (byte)(-1 - ((l1 & 0xFF) + (l2 & 0xFF) & 0xFF) + 1 & 0xFF);
        byte[] frame = new byte[]{};
        byte[] packet = new byte[]{};
        try {
            frame = TCMPUtils.concatByteArr({l1, l2, lcs}, family, {code}, data);
            packet = TCMPUtils.concatByteArr(frame, TCMPUtils.calculateCRCBitwise(frame));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return packet;
    }
}

