/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses;

import androidx.annotation.NonNull;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.AbstractSystemMessage;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ConfigureKioskModeResponse
extends AbstractSystemMessage {
    public static final byte COMMAND_CODE = 12;
    private byte pollingSetting;
    private byte ndefSetting;
    private int heartbeatPeriod;
    private byte scanErrorSetting;
    private int successfulScanLedTimeout = 50;
    private boolean hasSuccessfulScanLedTimeout;
    private int failedScanLedTimeout = 50;
    private boolean hasFailedScanLedTimeout;
    private int postScanDelayTimeout = 200;
    private boolean hasPostScanDelayTimeout;

    public ConfigureKioskModeResponse() {
        this.pollingSetting = 0;
        this.ndefSetting = 0;
        this.heartbeatPeriod = 15;
        this.scanErrorSetting = 0;
    }

    public ConfigureKioskModeResponse(byte pollingSetting, byte ndefSetting, int heartbeatPeriod, byte scanErrorSetting) {
        this.pollingSetting = pollingSetting;
        this.ndefSetting = ndefSetting;
        if (heartbeatPeriod > 255 || heartbeatPeriod < 0) {
            throw new IllegalArgumentException("the heartbeat period must be between 0 and 255s, inclusive");
        }
        this.heartbeatPeriod = heartbeatPeriod;
        this.scanErrorSetting = scanErrorSetting;
    }

    public byte getPollingSetting() {
        return this.pollingSetting;
    }

    public void setPollingSetting(byte pollingSetting) {
        this.pollingSetting = pollingSetting;
    }

    public byte getNdefSetting() {
        return this.ndefSetting;
    }

    public void setNdefSetting(byte ndefSetting) {
        this.ndefSetting = ndefSetting;
    }

    public int getHeartbeatPeriod() {
        return this.heartbeatPeriod;
    }

    public void setHeartbeatPeriod(int heartbeatPeriod) {
        if (heartbeatPeriod > 255 || heartbeatPeriod < 0) {
            throw new IllegalArgumentException("the heartbeat period must be between 0 and 255, inclusive");
        }
        this.heartbeatPeriod = heartbeatPeriod;
    }

    public byte getScanErrorSetting() {
        return this.scanErrorSetting;
    }

    public void setScanErrorSetting(byte scanErrorSetting) {
        this.scanErrorSetting = scanErrorSetting;
    }

    public int getSuccessfulScanLedTimeout() {
        return this.successfulScanLedTimeout;
    }

    public void setSuccessfulScanLedTimeout(int successfulScanLedTimeout) {
        if (successfulScanLedTimeout > 65535 || successfulScanLedTimeout < 0) {
            throw new IllegalArgumentException("the successful scan led timeout must be between 0 and 65535ms, inclusive");
        }
        this.hasSuccessfulScanLedTimeout = true;
        this.successfulScanLedTimeout = successfulScanLedTimeout;
    }

    public void unsetDidReceiveSuccessfulScanLedTimeout() {
        this.hasSuccessfulScanLedTimeout = false;
    }

    public boolean didReceiveSuccessfulScanLedTimeout() {
        return this.hasSuccessfulScanLedTimeout || this.hasFailedScanLedTimeout || this.hasPostScanDelayTimeout;
    }

    public int getFailedScanLedTimeout() {
        return this.failedScanLedTimeout;
    }

    public void setFailedScanLedTimeout(int failedScanLedTimeout) {
        if (failedScanLedTimeout > 65535 || failedScanLedTimeout < 0) {
            throw new IllegalArgumentException("the failed scan led timeout must be between 0 and 65535ms, inclusive");
        }
        this.hasFailedScanLedTimeout = true;
        this.failedScanLedTimeout = failedScanLedTimeout;
    }

    public void unsetDidReceiveFailedScanLedTimeout() {
        this.hasFailedScanLedTimeout = false;
    }

    public boolean didReceiveFailedScanLedTimeout() {
        return this.hasFailedScanLedTimeout || this.hasPostScanDelayTimeout;
    }

    public int getPostScanDelayTimeout() {
        return this.postScanDelayTimeout;
    }

    public void setPostScanDelayTimeout(int postScanDelayTimeout) {
        if (postScanDelayTimeout > 65535 || postScanDelayTimeout < 0) {
            throw new IllegalArgumentException("the post scan delay timeout must be between 0 and 65535ms, inclusive");
        }
        this.hasPostScanDelayTimeout = true;
        this.postScanDelayTimeout = postScanDelayTimeout;
    }

    public void unsetDidReceivePostScanDelayTimeout() {
        this.hasPostScanDelayTimeout = false;
    }

    public boolean didReceivePostScanDelayTimeout() {
        return this.hasPostScanDelayTimeout;
    }

    public void parsePayload(@NonNull byte[] payload) throws MalformedPayloadException {
        if (payload.length < 4) {
            throw new IllegalArgumentException("Payload too short");
        }
        this.pollingSetting = payload[0];
        this.ndefSetting = payload[1];
        this.heartbeatPeriod = payload[2] & 0xFF;
        this.scanErrorSetting = payload[3];
        this.failedScanLedTimeout = 50;
        this.successfulScanLedTimeout = 50;
        this.postScanDelayTimeout = 200;
        this.hasPostScanDelayTimeout = false;
        this.hasSuccessfulScanLedTimeout = false;
        this.hasFailedScanLedTimeout = false;
        if (payload.length >= 6) {
            this.hasSuccessfulScanLedTimeout = true;
            this.successfulScanLedTimeout = Utils.uint16ToInt(new byte[]{payload[4], payload[5]});
        }
        if (payload.length >= 8) {
            this.hasFailedScanLedTimeout = true;
            this.failedScanLedTimeout = Utils.uint16ToInt(new byte[]{payload[6], payload[7]});
        }
        if (payload.length >= 10) {
            this.hasPostScanDelayTimeout = true;
            this.postScanDelayTimeout = Utils.uint16ToInt(new byte[]{payload[8], payload[9]});
        }
    }

    @NonNull
    public byte[] getPayload() {
        byte[] delayArr;
        ByteArrayOutputStream stream = new ByteArrayOutputStream(4);
        stream.write(this.pollingSetting);
        stream.write(this.ndefSetting);
        stream.write((byte)this.heartbeatPeriod);
        stream.write(this.scanErrorSetting);
        if (this.hasPostScanDelayTimeout || this.hasFailedScanLedTimeout || this.hasSuccessfulScanLedTimeout) {
            delayArr = Utils.intToUint16(this.successfulScanLedTimeout);
            try {
                stream.write(delayArr);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.hasPostScanDelayTimeout || this.hasFailedScanLedTimeout) {
            delayArr = Utils.intToUint16(this.failedScanLedTimeout);
            try {
                stream.write(delayArr);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.hasPostScanDelayTimeout) {
            delayArr = Utils.intToUint16(this.postScanDelayTimeout);
            try {
                stream.write(delayArr);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stream.toByteArray();
    }

    public byte getCommandCode() {
        return 12;
    }
}

