/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands;

import androidx.annotation.NonNull;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.AbstractSystemMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class SetConfigItemCommand
extends AbstractSystemMessage {
    public static final byte COMMAND_CODE = 1;
    private byte parameter;
    private byte[] value;

    public static SetConfigItemCommand makeBluetoothPINParingCommand(String pin) {
        if (pin.length() != 6) {
            throw new IllegalArgumentException("PIN must be six characters long");
        }
        if (!pin.matches("[0-9]+")) {
            throw new IllegalArgumentException("PIN must be only numbers");
        }
        byte[] configOptions = pin.getBytes(StandardCharsets.US_ASCII);
        return new SetConfigItemCommand(8, configOptions);
    }

    public SetConfigItemCommand() {
        this.parameter = 0;
        this.value = new byte[0];
    }

    public SetConfigItemCommand(byte parameter, byte value) {
        this.parameter = parameter;
        this.value = new byte[]{value};
    }

    public SetConfigItemCommand(byte parameter) {
        this.parameter = parameter;
        this.value = new byte[0];
    }

    public SetConfigItemCommand(byte parameter, @NonNull byte[] value) {
        this.parameter = parameter;
        this.value = value;
    }

    public byte getParameter() {
        return this.parameter;
    }

    public void setParameter(byte parameter) {
        this.parameter = parameter;
    }

    public byte getValue() {
        if (this.value.length > 0) {
            return this.value[0];
        }
        return 0;
    }

    public void setValue(byte value) {
        this.value = new byte[]{value};
    }

    @NonNull
    public byte[] getMultibyteValue() {
        return this.value;
    }

    public void setMultibyteValue(@NonNull byte[] value) {
        this.value = value;
    }

    public void parsePayload(@NonNull byte[] payload) throws MalformedPayloadException {
        if (payload.length < 1) {
            throw new IllegalArgumentException("Payload malformed");
        }
        this.parameter = payload[0];
        this.value = payload.length >= 2 ? Arrays.copyOfRange(payload, 1, payload.length) : new byte[0];
    }

    @NonNull
    public byte[] getPayload() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(1 + this.value.length);
        stream.write(this.parameter);
        try {
            stream.write(this.value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stream.toByteArray();
    }

    public byte getCommandCode() {
        return 1;
    }

    public static interface ValueBytes {
        public static final byte USB_PROFILE_NONE = 1;
        public static final byte USB_PROFILE_CDC = 2;
        public static final byte USB_PROFILE_NATIVE = 3;
        public static final byte USB_PROFILE_HID = 4;
    }

    public static interface ParameterBytes {
        public static final byte TYPE_2_IDENTIFICATION = 1;
        public static final byte DATA_THROTTLING = 2;
        public static final byte DUAL_TYPE1_2_DECTION = 3;
        public static final byte BUZZER_DURATION = 5;
        public static final byte GREEN_LED_DURATION = 6;
        public static final byte RED_LED_DURATION = 7;
        public static final byte ENABLE_BLUETOOTH_PIN_PARING = 8;
        public static final byte DISABLE_BLUETOOTH_PIN_PAIRING = 9;
        public static final byte DISABLE_BLUE_LIGHT_DURING_TAG_POLLING = 10;
        public static final byte ENABLE_BLUE_LIGHT_DURING_TAG_POLLING = 11;
        public static final byte CLEAR_BLUETOOTH_BONDING_CACHE = 12;
        public static final byte SET_USB_PROFILE = 13;
    }
}

