/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands;

import androidx.annotation.NonNull;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.AbstractSystemMessage;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ConfigureOnboardScanCooldownCommand
extends AbstractSystemMessage {
    public static final byte COMMAND_CODE = 8;
    private byte cooldownSetting;
    private int bufferSize;

    public ConfigureOnboardScanCooldownCommand() {
        this.cooldownSetting = 0;
        this.bufferSize = 10;
    }

    public ConfigureOnboardScanCooldownCommand(byte cooldownSetting, int bufferSize) {
        this.cooldownSetting = cooldownSetting;
        if (bufferSize > 10 || bufferSize < 0) {
            throw new IllegalArgumentException("the buffer size must be between 0 and 10, inclusive");
        }
        this.bufferSize = bufferSize;
    }

    public byte getCooldownSetting() {
        return this.cooldownSetting;
    }

    public void setCooldownSetting(byte cooldownSetting) {
        this.cooldownSetting = cooldownSetting;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize > 10 || bufferSize < 0) {
            throw new IllegalArgumentException("the buffer size must be between 0 and 10, inclusive");
        }
        this.bufferSize = bufferSize;
    }

    public void parsePayload(@NonNull byte[] payload) throws MalformedPayloadException {
        if (payload.length < 3) {
            throw new IllegalArgumentException("Payload too short");
        }
        this.cooldownSetting = payload[0];
        int tempBuf = Utils.uint16ToInt(new byte[]{payload[1], payload[2]});
        if (tempBuf > 10 || tempBuf < 0) {
            throw new IllegalArgumentException("payload specified an invalid value");
        }
        this.bufferSize = tempBuf;
    }

    @NonNull
    public byte[] getPayload() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(4);
        stream.write(this.cooldownSetting);
        try {
            stream.write(Utils.intToUint16(this.bufferSize));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stream.toByteArray();
    }

    public byte getCommandCode() {
        return 8;
    }

    public static interface CooldownSettings {
        public static final byte NO_CHANGE = 0;
        public static final byte ENABLE_COOLDOWN = 1;
        public static final byte DISABLE_COOLDOWN = 2;
    }
}

