/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.systemfamily;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.taptrack.tcmptappy2.CommandFamilyMessageResolver;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.TCMPMessage;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.AbstractSystemMessage;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.ActivateBlueLEDCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.ActivateBlueLEDForDurationCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.ActivateBuzzerCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.ActivateBuzzerForDurationCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.ActivateGreenLEDCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.ActivateGreenLEDForDurationCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.ActivateRedLEDCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.ActivateRedLEDForDurationCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.ConfigureKioskModeCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.ConfigureOnboardScanCooldownCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.DeactivateBlueLEDCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.DeactivateBuzzerCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.DeactivateGreenLEDCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.DeactivateRedLEDCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.DisableHostHeartbeatTransmissionCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.GetBatteryLevelCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.GetClockStatusCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.GetFirmwareVersionCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.GetHardwareVersionCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.GetIndicatorStatusCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.GetNVMConfigCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.PingCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.SetConfigItemCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.SetNVMConfigCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.BlueLEDActivatedResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.BlueLEDDeactivatedResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.BuzzerActivatedResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.BuzzerDeactivatedResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.ClockStatusResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.ConfigItemResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.ConfigureKioskModeResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.ConfigureOnboardScanCooldownResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.CrcMismatchErrorResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.DisableHostHeartbeatTransmissionResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.FirmwareVersionResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.GetBatteryLevelResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.GetNVMConfigResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.GreenLEDActivatedResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.GreenLEDDeactivatedResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.HardwareVersionResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.ImproperMessageFormatResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.IndicatorStatusResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.LcsMismatchErrorResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.LengthMismatchErrorResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.PingResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.RedLEDActivatedResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.RedLEDDeactivatedResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.SetNVMConfigResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.SystemErrorResponse;
import java.util.Arrays;

public class SystemCommandResolver
implements CommandFamilyMessageResolver {
    public static final byte[] FAMILY_ID = new byte[]{0, 0};

    private static void assertFamilyMatches(@NonNull TCMPMessage message) {
        if (!Arrays.equals(message.getCommandFamily(), FAMILY_ID)) {
            throw new IllegalArgumentException("Specified message is for a different command family");
        }
    }

    @Nullable
    public TCMPMessage resolveCommand(@NonNull TCMPMessage message) throws MalformedPayloadException {
        AbstractSystemMessage parsedMessage;
        SystemCommandResolver.assertFamilyMatches(message);
        switch (message.getCommandCode()) {
            case -2: {
                parsedMessage = new GetHardwareVersionCommand();
                break;
            }
            case -1: {
                parsedMessage = new GetFirmwareVersionCommand();
                break;
            }
            case 2: {
                parsedMessage = new GetBatteryLevelCommand();
                break;
            }
            case 5: {
                parsedMessage = new GetClockStatusCommand();
                break;
            }
            case -3: {
                parsedMessage = new PingCommand();
                break;
            }
            case 1: {
                parsedMessage = new SetConfigItemCommand();
                break;
            }
            case 6: {
                parsedMessage = new ConfigureKioskModeCommand();
                break;
            }
            case 8: {
                parsedMessage = new ConfigureOnboardScanCooldownCommand();
                break;
            }
            case 16: {
                parsedMessage = new ActivateBlueLEDCommand();
                break;
            }
            case 10: {
                parsedMessage = new ActivateRedLEDCommand();
                break;
            }
            case 13: {
                parsedMessage = new ActivateGreenLEDCommand();
                break;
            }
            case 19: {
                parsedMessage = new ActivateBuzzerCommand();
                break;
            }
            case 17: {
                parsedMessage = new DeactivateBlueLEDCommand();
                break;
            }
            case 11: {
                parsedMessage = new DeactivateRedLEDCommand();
                break;
            }
            case 14: {
                parsedMessage = new DeactivateGreenLEDCommand();
                break;
            }
            case 20: {
                parsedMessage = new DeactivateBuzzerCommand();
                break;
            }
            case 18: {
                parsedMessage = new ActivateBlueLEDForDurationCommand();
                break;
            }
            case 12: {
                parsedMessage = new ActivateRedLEDForDurationCommand();
                break;
            }
            case 15: {
                parsedMessage = new ActivateGreenLEDForDurationCommand();
                break;
            }
            case 21: {
                parsedMessage = new ActivateBuzzerForDurationCommand();
                break;
            }
            case 22: {
                parsedMessage = new GetIndicatorStatusCommand();
                break;
            }
            case 7: {
                parsedMessage = new DisableHostHeartbeatTransmissionCommand();
                break;
            }
            case 23: {
                parsedMessage = new GetNVMConfigCommand();
                break;
            }
            case 24: {
                parsedMessage = new SetNVMConfigCommand();
                break;
            }
            default: {
                return null;
            }
        }
        parsedMessage.parsePayload(message.getPayload());
        return parsedMessage;
    }

    @Nullable
    public TCMPMessage resolveResponse(@NonNull TCMPMessage message) throws MalformedPayloadException {
        AbstractSystemMessage parsedMessage;
        SystemCommandResolver.assertFamilyMatches(message);
        switch (message.getCommandCode()) {
            case 7: {
                parsedMessage = new ConfigItemResponse();
                break;
            }
            case 12: {
                parsedMessage = new ConfigureKioskModeResponse();
                break;
            }
            case 3: {
                parsedMessage = new CrcMismatchErrorResponse();
                break;
            }
            case 6: {
                parsedMessage = new FirmwareVersionResponse();
                break;
            }
            case 8: {
                parsedMessage = new GetBatteryLevelResponse();
                break;
            }
            case 5: {
                parsedMessage = new HardwareVersionResponse();
                break;
            }
            case 11: {
                parsedMessage = new ClockStatusResponse();
                break;
            }
            case 1: {
                parsedMessage = new ImproperMessageFormatResponse();
                break;
            }
            case 2: {
                parsedMessage = new LcsMismatchErrorResponse();
                break;
            }
            case 4: {
                parsedMessage = new LengthMismatchErrorResponse();
                break;
            }
            case -3: {
                parsedMessage = new PingResponse();
                break;
            }
            case 127: {
                parsedMessage = new SystemErrorResponse();
                break;
            }
            case 13: {
                parsedMessage = new ConfigureOnboardScanCooldownResponse();
                break;
            }
            case 18: {
                parsedMessage = new BlueLEDActivatedResponse();
                break;
            }
            case 14: {
                parsedMessage = new RedLEDActivatedResponse();
                break;
            }
            case 16: {
                parsedMessage = new GreenLEDActivatedResponse();
                break;
            }
            case 20: {
                parsedMessage = new BuzzerActivatedResponse();
                break;
            }
            case 19: {
                parsedMessage = new BlueLEDDeactivatedResponse();
                break;
            }
            case 15: {
                parsedMessage = new RedLEDDeactivatedResponse();
                break;
            }
            case 17: {
                parsedMessage = new GreenLEDDeactivatedResponse();
                break;
            }
            case 21: {
                parsedMessage = new BuzzerDeactivatedResponse();
                break;
            }
            case 22: {
                parsedMessage = new IndicatorStatusResponse();
                break;
            }
            case 23: {
                parsedMessage = new DisableHostHeartbeatTransmissionResponse();
                break;
            }
            case 24: {
                parsedMessage = new GetNVMConfigResponse();
                break;
            }
            case 25: {
                parsedMessage = new SetNVMConfigResponse();
                break;
            }
            default: {
                return null;
            }
        }
        parsedMessage.parsePayload(message.getPayload());
        return parsedMessage;
    }

    @NonNull
    @Size(value=2L)
    public byte[] getCommandFamilyId() {
        return FAMILY_ID;
    }
}

