/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses;

import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.AbstractSystemMessage;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ConfigureOnboardScanCooldownResponse
extends AbstractSystemMessage {
    public static final byte COMMAND_CODE = 13;
    private boolean cooldownEnabled;
    private int bufferSize;

    public ConfigureOnboardScanCooldownResponse() {
    }

    public ConfigureOnboardScanCooldownResponse(boolean cooldownEnabled, int bufferSize) {
        if (bufferSize > 10 || bufferSize < 0) {
            throw new IllegalArgumentException("buffer size must be between 10 and 0 inclusive");
        }
        this.cooldownEnabled = cooldownEnabled;
        this.bufferSize = bufferSize;
    }

    public boolean isCooldownEnabled() {
        return this.cooldownEnabled;
    }

    public void setCooldownEnabled(boolean cooldownEnabled) {
        this.cooldownEnabled = cooldownEnabled;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize > 10 || bufferSize < 0) {
            throw new IllegalArgumentException("buffer size must be between 0 and 10 inclusive");
        }
        this.bufferSize = bufferSize;
    }

    public void parsePayload(byte[] payload) throws MalformedPayloadException {
        if (payload.length < 3) {
            throw new IllegalArgumentException("payload must be at least three bytes long");
        }
        int tempBuf = Utils.uint16ToInt(new byte[]{payload[1], payload[2]});
        if (tempBuf > 10 || tempBuf < 0) {
            throw new IllegalArgumentException("buffer size must be between 0 and 10 inclusive");
        }
        this.cooldownEnabled = payload[0] == 1;
        this.bufferSize = tempBuf;
    }

    public byte[] getPayload() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(3);
        byteArrayOutputStream.write(this.cooldownEnabled ? 1 : 0);
        try {
            byteArrayOutputStream.write(Utils.intToUint16(this.bufferSize));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte getCommandCode() {
        return 13;
    }
}

