/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands;

import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.AbstractSystemMessage;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ConfigureKioskModeCommand
extends AbstractSystemMessage {
    public static final byte COMMAND_CODE = 6;
    private byte pollingSetting;
    private byte ndefSetting;
    public static final int DEFAULT_HEARTBEAT_PERIOD = 15;
    private int heartbeatPeriod = 15;
    private byte scanErrorSetting;
    public static final int DEFAULT_SUCCESSFUL_SCAN_LED_TIMEOUT = 50;
    private int successfulScanLedTimeout = 50;
    private boolean hasSuccessfulScanLedTimeout;
    public static final int DEFAULT_FAILED_SCAN_LED_TIMEOUT = 50;
    private int failedScanLedTimeout = 50;
    private boolean hasFailedScanLedTimeout;
    public static final int DEFAULT_POST_SCAN_DELAY_TIMEOUT = 200;
    private int postScanDelayTimeout = 200;
    private boolean hasPostScanDelayTimeout;
    public static final int DEFAULT_POST_SUCCESSFUL_SCAN_BEEP_DURATION = 50;
    private int postSuccessfulScanBeepDuration = 50;
    private boolean hasPostScanBeepDuration;

    public ConfigureKioskModeCommand() {
        this.pollingSetting = 0;
        this.ndefSetting = 0;
        this.heartbeatPeriod = 15;
        this.scanErrorSetting = 0;
    }

    public ConfigureKioskModeCommand(byte pollingSetting, byte ndefSetting, int heartbeatPeriod, byte scanErrorSetting) {
        this.pollingSetting = pollingSetting;
        this.ndefSetting = ndefSetting;
        if (heartbeatPeriod > 255 || heartbeatPeriod < 0) {
            throw new IllegalArgumentException("the heartbeat period must be between 0 and 255s, inclusive");
        }
        this.heartbeatPeriod = heartbeatPeriod;
        this.scanErrorSetting = scanErrorSetting;
    }

    public byte getPollingSetting() {
        return this.pollingSetting;
    }

    public void setPollingSetting(byte pollingSetting) {
        this.pollingSetting = pollingSetting;
    }

    public byte getNdefSetting() {
        return this.ndefSetting;
    }

    public void setNdefSetting(byte ndefSetting) {
        this.ndefSetting = ndefSetting;
    }

    public int getHeartbeatPeriod() {
        return this.heartbeatPeriod;
    }

    public void setHeartbeatPeriod(int heartbeatPeriod) {
        if (heartbeatPeriod > 255 || heartbeatPeriod < 0) {
            throw new IllegalArgumentException("the heartbeat period must be between 0 and 255, inclusive");
        }
        this.heartbeatPeriod = heartbeatPeriod;
    }

    public byte getScanErrorSetting() {
        return this.scanErrorSetting;
    }

    public void setScanErrorSetting(byte scanErrorSetting) {
        this.scanErrorSetting = scanErrorSetting;
    }

    public int getSuccessfulScanLedTimeout() {
        return this.successfulScanLedTimeout;
    }

    public void setSuccessfulScanLedTimeout(int successfulScanLedTimeout) {
        if (successfulScanLedTimeout > 65535 || successfulScanLedTimeout < 0) {
            throw new IllegalArgumentException("the successful scan led timeout must be between 0 and 65535ms, inclusive");
        }
        this.hasSuccessfulScanLedTimeout = true;
        this.successfulScanLedTimeout = successfulScanLedTimeout;
    }

    public void disableTransmittingSuccessfulScanLedTimeout() {
        this.hasSuccessfulScanLedTimeout = false;
    }

    public boolean willTransmitSuccessfulScanLedTimeout() {
        return this.hasSuccessfulScanLedTimeout || this.hasFailedScanLedTimeout || this.hasPostScanDelayTimeout;
    }

    public int getFailedScanLedTimeout() {
        return this.failedScanLedTimeout;
    }

    public void setFailedScanLedTimeout(int failedScanLedTimeout) {
        if (failedScanLedTimeout > 65535 || failedScanLedTimeout < 0) {
            throw new IllegalArgumentException("the failed scan led timeout must be between 0 and 65535ms, inclusive");
        }
        this.hasFailedScanLedTimeout = true;
        this.failedScanLedTimeout = failedScanLedTimeout;
    }

    public void disableTransmittingFailedScanLedTimeout() {
        this.hasFailedScanLedTimeout = false;
    }

    public boolean willTransmitFailedScanLedTimeout() {
        return this.hasFailedScanLedTimeout || this.hasPostScanDelayTimeout;
    }

    public int getPostScanDelayTimeout() {
        return this.postScanDelayTimeout;
    }

    public void setPostScanDelayTimeout(int postScanDelayTimeout) {
        if (postScanDelayTimeout > 65535 || postScanDelayTimeout < 0) {
            throw new IllegalArgumentException("the post scan delay timeout must be between 0 and 65535ms, inclusive");
        }
        this.hasPostScanDelayTimeout = true;
        this.postScanDelayTimeout = postScanDelayTimeout;
    }

    public void disableTransmittingPostScanDelayTimeout() {
        this.hasPostScanDelayTimeout = false;
    }

    public boolean willTransmitPostScanDelayTimeout() {
        return this.hasPostScanDelayTimeout;
    }

    public int getPostSuccessfulScanBeepDuration() {
        return this.postSuccessfulScanBeepDuration;
    }

    public void setPostSuccessfulScanBeepDuration(int postSuccessfulScanBeepDuration) {
        if (postSuccessfulScanBeepDuration > 65535 || postSuccessfulScanBeepDuration <= 1) {
            throw new IllegalArgumentException("the post scan delay timeout must be between 0 and 65535ms, inclusive");
        }
        this.hasPostScanBeepDuration = true;
        this.postSuccessfulScanBeepDuration = postSuccessfulScanBeepDuration;
    }

    public void disableTransmittingPostScanBeepDuration() {
        this.hasPostScanBeepDuration = false;
    }

    public boolean willTransmitPostScanBeepDuration() {
        return this.hasPostScanBeepDuration;
    }

    public void parsePayload(byte[] payload) throws MalformedPayloadException {
        if (payload.length < 4) {
            throw new IllegalArgumentException("Payload too short");
        }
        this.pollingSetting = payload[0];
        this.ndefSetting = payload[1];
        this.heartbeatPeriod = payload[2] & 0xFF;
        this.scanErrorSetting = payload[3];
        this.failedScanLedTimeout = 50;
        this.successfulScanLedTimeout = 50;
        this.postScanDelayTimeout = 200;
        this.hasPostScanDelayTimeout = false;
        this.hasSuccessfulScanLedTimeout = false;
        this.hasFailedScanLedTimeout = false;
        if (payload.length >= 6) {
            this.hasSuccessfulScanLedTimeout = true;
            this.successfulScanLedTimeout = Utils.uint16ToInt(new byte[]{payload[4], payload[5]});
        }
        if (payload.length >= 8) {
            this.hasFailedScanLedTimeout = true;
            this.failedScanLedTimeout = Utils.uint16ToInt(new byte[]{payload[6], payload[7]});
        }
        if (payload.length >= 10) {
            this.hasPostScanDelayTimeout = true;
            this.postScanDelayTimeout = Utils.uint16ToInt(new byte[]{payload[8], payload[9]});
        }
        if (payload.length >= 12) {
            this.hasPostScanBeepDuration = true;
            this.postSuccessfulScanBeepDuration = Utils.uint16ToInt(new byte[]{payload[10], payload[11]});
        }
    }

    public byte[] getPayload() {
        byte[] delayArr;
        ByteArrayOutputStream stream = new ByteArrayOutputStream(4);
        stream.write(this.pollingSetting);
        stream.write(this.ndefSetting);
        stream.write((byte)this.heartbeatPeriod);
        stream.write(this.scanErrorSetting);
        if (this.hasPostScanDelayTimeout || this.hasFailedScanLedTimeout || this.hasSuccessfulScanLedTimeout) {
            delayArr = Utils.intToUint16(this.successfulScanLedTimeout);
            try {
                stream.write(delayArr);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.hasPostScanDelayTimeout || this.hasFailedScanLedTimeout) {
            delayArr = Utils.intToUint16(this.failedScanLedTimeout);
            try {
                stream.write(delayArr);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.hasPostScanDelayTimeout) {
            delayArr = Utils.intToUint16(this.postScanDelayTimeout);
            try {
                stream.write(delayArr);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.hasPostScanBeepDuration) {
            byte[] durationArr = Utils.intToUint16(this.postSuccessfulScanBeepDuration);
            try {
                stream.write(durationArr);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stream.toByteArray();
    }

    public byte getCommandCode() {
        return 6;
    }

    public static interface ScanErrorSettings {
        public static final byte NO_CHANGE = 0;
        public static final byte ENABLE_SCAN_ERROR_MESSAGES = 1;
        public static final byte DISABLE_SCAN_ERROR_MESSAGES = 2;
    }

    public static interface NdefSettings {
        public static final byte NO_CHANGE = 0;
        public static final byte ENABLE_NDEF_DETECTION = 1;
        public static final byte DISABLE_NDEF_DETECTION = 2;
    }

    public static interface PollingSettings {
        public static final byte NO_CHANGE = 0;
        public static final byte ENABLE_DUAL_POLLING = 1;
        public static final byte DISABLE_DUAL_POLLING = 2;
    }
}

