/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.systemfamily;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.taptrack.tcmptappy2.CommandFamilyMessageResolver;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.TCMPMessage;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.AbstractSystemMessage;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.ConfigureKioskModeCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.GetBatteryLevelCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.GetFirmwareVersionCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.GetHardwareVersionCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.PingCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.commands.SetConfigItemCommand;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.ConfigItemResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.ConfigureKioskModeResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.CrcMismatchErrorResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.FirmwareVersionResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.GetBatteryLevelResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.HardwareVersionResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.ImproperMessageFormatResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.LcsMismatchErrorResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.LengthMismatchErrorResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.PingResponse;
import com.taptrack.tcmptappy2.commandfamilies.systemfamily.responses.SystemErrorResponse;
import java.util.Arrays;

public class SystemCommandResolver
implements CommandFamilyMessageResolver {
    static final byte[] FAMILY_ID = new byte[]{0, 0};

    private static void assertFamilyMatches(@NonNull TCMPMessage message) {
        if (!Arrays.equals(message.getCommandFamily(), FAMILY_ID)) {
            throw new IllegalArgumentException("Specified message is for a different command family");
        }
    }

    @Nullable
    public TCMPMessage resolveCommand(@NonNull TCMPMessage message) throws MalformedPayloadException {
        AbstractSystemMessage parsedMessage;
        SystemCommandResolver.assertFamilyMatches(message);
        switch (message.getCommandCode()) {
            case -2: {
                parsedMessage = new GetHardwareVersionCommand();
                break;
            }
            case -1: {
                parsedMessage = new GetFirmwareVersionCommand();
                break;
            }
            case 2: {
                parsedMessage = new GetBatteryLevelCommand();
                break;
            }
            case -3: {
                parsedMessage = new PingCommand();
                break;
            }
            case 1: {
                parsedMessage = new SetConfigItemCommand();
                break;
            }
            case 6: {
                parsedMessage = new ConfigureKioskModeCommand();
                break;
            }
            default: {
                return null;
            }
        }
        parsedMessage.parsePayload(message.getPayload());
        return parsedMessage;
    }

    @Nullable
    public TCMPMessage resolveResponse(@NonNull TCMPMessage message) throws MalformedPayloadException {
        AbstractSystemMessage parsedMessage;
        SystemCommandResolver.assertFamilyMatches(message);
        switch (message.getCommandCode()) {
            case 7: {
                parsedMessage = new ConfigItemResponse();
                break;
            }
            case 12: {
                parsedMessage = new ConfigureKioskModeResponse();
                break;
            }
            case 3: {
                parsedMessage = new CrcMismatchErrorResponse();
                break;
            }
            case 6: {
                parsedMessage = new FirmwareVersionResponse();
                break;
            }
            case 8: {
                parsedMessage = new GetBatteryLevelResponse();
                break;
            }
            case 5: {
                parsedMessage = new HardwareVersionResponse();
                break;
            }
            case 1: {
                parsedMessage = new ImproperMessageFormatResponse();
                break;
            }
            case 2: {
                parsedMessage = new LcsMismatchErrorResponse();
                break;
            }
            case 4: {
                parsedMessage = new LengthMismatchErrorResponse();
                break;
            }
            case -3: {
                parsedMessage = new PingResponse();
                break;
            }
            case 127: {
                parsedMessage = new SystemErrorResponse();
                break;
            }
            default: {
                return null;
            }
        }
        parsedMessage.parsePayload(message.getPayload());
        return parsedMessage;
    }

    @NonNull
    @Size(value=2L)
    public byte[] getCommandFamilyId() {
        return FAMILY_ID;
    }
}

