/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses;

import androidx.annotation.NonNull;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;
import java.util.Arrays;

public class TagWrittenResponse
extends AbstractBasicNfcMessage {
    public static final byte COMMAND_CODE = 5;
    byte[] tagCode;
    byte tagType;

    public TagWrittenResponse() {
        this.tagCode = new byte[7];
        this.tagType = 0;
    }

    public TagWrittenResponse(byte[] tagCode, byte tagType) {
        this.tagCode = tagCode;
        this.tagType = tagType;
    }

    public void parsePayload(@NonNull byte[] payload) throws MalformedPayloadException {
        this.tagType = payload[0];
        this.tagCode = Arrays.copyOfRange(payload, 1, payload.length);
    }

    public byte[] getTagCode() {
        return this.tagCode;
    }

    public void setTagCode(byte[] tagCode) {
        this.tagCode = tagCode;
    }

    public byte getTagType() {
        return this.tagType;
    }

    public void setTagType(byte tagType) {
        this.tagType = tagType;
    }

    @NonNull
    public byte[] getPayload() {
        byte[] payload = new byte[this.tagCode.length + 1];
        payload[0] = this.tagType;
        System.arraycopy(this.tagCode, 0, payload, 1, this.tagCode.length);
        return payload;
    }

    public byte getCommandCode() {
        return 5;
    }
}

