/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses;

import androidx.annotation.NonNull;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;
import java.util.Arrays;

public class TagFoundResponse
extends AbstractBasicNfcMessage {
    public static final byte COMMAND_CODE = 1;
    byte[] mTagCode;
    byte mTagType;

    public TagFoundResponse() {
        this.mTagCode = new byte[7];
        this.mTagType = 0;
    }

    public void parsePayload(@NonNull byte[] payload) throws MalformedPayloadException {
        if (payload.length < 5) {
            throw new MalformedPayloadException();
        }
        this.mTagType = payload[0];
        this.mTagCode = Arrays.copyOfRange(payload, 1, payload.length);
    }

    public TagFoundResponse(byte[] tagCode, byte tagType) {
        this.mTagCode = tagCode;
        this.mTagType = tagType;
    }

    public byte[] getTagCode() {
        return this.mTagCode;
    }

    public byte getTagType() {
        return this.mTagType;
    }

    @NonNull
    public byte[] getPayload() {
        byte[] payload = new byte[this.mTagCode.length + 1];
        payload[0] = this.mTagType;
        System.arraycopy(this.mTagCode, 0, payload, 1, this.mTagCode.length);
        return payload;
    }

    public byte getCommandCode() {
        return 1;
    }
}

