/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses;

import androidx.annotation.NonNull;
import androidx.annotation.Size;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;

public class EmulationStoppedResponse
extends AbstractBasicNfcMessage {
    public static final byte COMMAND_CODE = 8;
    private byte stopCode = 0;
    @Size(value=2L)
    private final byte[] totalScansBytes = new byte[]{0, 0};

    public EmulationStoppedResponse() {
    }

    public EmulationStoppedResponse(@NonNull byte[] payload) throws MalformedPayloadException {
        this.parsePayload(payload);
    }

    public void parsePayload(@NonNull byte[] payload) throws MalformedPayloadException {
        if (payload.length < 3) {
            throw new MalformedPayloadException("Payload too short");
        }
        this.stopCode = payload[0];
        System.arraycopy(payload, 1, this.totalScansBytes, 0, 2);
    }

    @NonNull
    public byte[] getPayload() {
        byte[] payload = new byte[3];
        payload[0] = this.stopCode;
        System.arraycopy(this.totalScansBytes, 0, payload, 1, 2);
        return payload;
    }

    public byte getCommandCode() {
        return 8;
    }

    byte getStopCode() {
        return this.stopCode;
    }

    @Size(value=2L)
    byte[] getTotalScansBytes() {
        return this.totalScansBytes;
    }
}

