/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses;

import androidx.annotation.NonNull;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;
import java.util.Arrays;

public class AutoPollTagExitedResponse
extends AbstractBasicNfcMessage {
    public static final byte COMMAND_CODE = 13;
    private byte detectedTagType;
    private byte[] tagMetadata;

    public AutoPollTagExitedResponse() {
        this.detectedTagType = (byte)5;
        this.tagMetadata = new byte[0];
    }

    public AutoPollTagExitedResponse(byte detectedTagType, byte[] tagMetadata) {
        this.detectedTagType = detectedTagType;
        this.tagMetadata = tagMetadata;
    }

    public void parsePayload(@NonNull byte[] payload) throws MalformedPayloadException {
        if (payload.length < 1) {
            throw new MalformedPayloadException();
        }
        this.detectedTagType = payload[0];
        this.tagMetadata = payload.length >= 2 ? Arrays.copyOfRange(payload, 1, payload.length) : new byte[0];
    }

    public byte getDetectedTagType() {
        return this.detectedTagType;
    }

    public void setDetectedTagType(byte detectedTagType) {
        this.detectedTagType = detectedTagType;
    }

    public byte[] getTagMetadata() {
        return this.tagMetadata;
    }

    public void setTagMetadata(byte[] tagMetadata) {
        this.tagMetadata = tagMetadata;
    }

    @NonNull
    public byte[] getPayload() {
        byte[] payload = new byte[this.tagMetadata.length + 1];
        payload[0] = this.detectedTagType;
        System.arraycopy(this.tagMetadata, 0, payload, 1, this.tagMetadata.length);
        return payload;
    }

    public byte getCommandCode() {
        return 13;
    }
}

