/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands;

import androidx.annotation.NonNull;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class LockTagCommand
extends AbstractBasicNfcMessage {
    public static final byte COMMAND_CODE = 8;
    protected byte timeout;
    protected byte[] tagCode;

    public LockTagCommand() {
        this.timeout = 0;
        this.tagCode = new byte[0];
    }

    public LockTagCommand(byte timeout, byte[] tagCode) {
        this.timeout = timeout;
        this.tagCode = tagCode;
    }

    public void parsePayload(@NonNull byte[] payload) throws MalformedPayloadException {
        byte uidLength;
        if (payload.length >= 2) {
            uidLength = payload[1];
            if (uidLength + 2 < payload.length) {
                throw new MalformedPayloadException("Payload too short to contain uid of specified length");
            }
        } else {
            throw new MalformedPayloadException("Payload too short to contain a lock tag command");
        }
        this.tagCode = Arrays.copyOfRange(payload, 2, 2 + uidLength);
        this.timeout = payload[0];
    }

    @NonNull
    public byte[] getPayload() {
        if (this.tagCode == null || this.tagCode.length == 0) {
            return new byte[]{this.timeout, 0};
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(2 + this.tagCode.length);
        outputStream.write(this.timeout);
        outputStream.write((byte)this.tagCode.length);
        try {
            outputStream.write(this.tagCode);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    public byte getCommandCode() {
        return 8;
    }

    public byte getTimeout() {
        return this.timeout;
    }

    public void setTimeout(byte timeout) {
        this.timeout = timeout;
    }

    public byte[] getTagCode() {
        return this.tagCode;
    }

    public void setTagCode(byte[] tagCode) {
        this.tagCode = tagCode;
    }
}

