/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands;

import androidx.annotation.NonNull;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;
import java.util.Arrays;

public class EmulateUriRecordCommand
extends AbstractBasicNfcMessage {
    public static final byte COMMAND_CODE = 10;
    private byte timeout = 0;
    private byte maxScans = 0;
    private byte uriPrefixCode = 0;
    @NonNull
    private byte[] uri = new byte[0];

    public EmulateUriRecordCommand() {
    }

    public EmulateUriRecordCommand(byte timeout, byte maxScans, byte uriPrefixCode, @NonNull byte[] uriBytes) {
        this.timeout = timeout;
        this.maxScans = maxScans;
        this.uriPrefixCode = uriPrefixCode;
        this.uri = uriBytes;
    }

    public EmulateUriRecordCommand(byte timeout, byte maxScans, byte uriPrefixCode, @NonNull String uri) {
        this(timeout, maxScans, uriPrefixCode, uri.getBytes());
    }

    public EmulateUriRecordCommand(@NonNull byte[] payload) throws MalformedPayloadException {
        this.parsePayload(payload);
    }

    public void parsePayload(@NonNull byte[] payload) throws MalformedPayloadException {
        if (payload.length < 3) {
            throw new MalformedPayloadException("Payload too short");
        }
        this.timeout = payload[0];
        this.maxScans = payload[1];
        this.uriPrefixCode = payload[2];
        if (payload.length > 3) {
            this.uri = Arrays.copyOfRange(payload, 3, payload.length);
        }
    }

    @NonNull
    public byte[] getPayload() {
        byte[] payload = new byte[3 + this.uri.length];
        payload[0] = this.timeout;
        payload[1] = this.maxScans;
        payload[2] = this.uriPrefixCode;
        System.arraycopy(this.uri, 0, payload, 3, this.uri.length);
        return payload;
    }

    public byte getCommandCode() {
        return 10;
    }
}

