/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands;

import androidx.annotation.NonNull;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;
import java.util.Arrays;

public class EmulateCustomNdefRecordCommand
extends AbstractBasicNfcMessage {
    public static final byte COMMAND_CODE = 11;
    private byte timeout = 0;
    private byte maxScans = 0;
    @NonNull
    private byte[] content = new byte[0];

    public EmulateCustomNdefRecordCommand() {
    }

    public EmulateCustomNdefRecordCommand(byte timeout, byte maxScans, @NonNull byte[] content) {
        this.timeout = timeout;
        this.maxScans = maxScans;
        this.content = content;
    }

    public EmulateCustomNdefRecordCommand(@NonNull byte[] payload) throws MalformedPayloadException {
        this.parsePayload(payload);
    }

    public void parsePayload(@NonNull byte[] payload) throws MalformedPayloadException {
        if (payload.length < 2) {
            throw new MalformedPayloadException("Payload too short");
        }
        this.timeout = payload[0];
        this.maxScans = payload[1];
        if (payload.length > 2) {
            this.content = Arrays.copyOfRange(payload, 2, payload.length);
        }
    }

    @NonNull
    public byte[] getPayload() {
        byte[] payload = new byte[2 + this.content.length];
        payload[0] = this.timeout;
        payload[1] = this.maxScans;
        System.arraycopy(this.content, 0, payload, 2, this.content.length);
        return payload;
    }

    public byte getCommandCode() {
        return 11;
    }
}

