/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands;

import androidx.annotation.NonNull;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;

public abstract class AbstractPollingCommand
extends AbstractBasicNfcMessage {
    byte timeout;
    byte pollingMode;

    public AbstractPollingCommand() {
        this.timeout = 0;
        this.pollingMode = (byte)2;
    }

    public AbstractPollingCommand(byte timeout, byte pollingMode) {
        this.timeout = timeout;
        this.pollingMode = pollingMode;
    }

    public void parsePayload(@NonNull byte[] payload) throws MalformedPayloadException {
        if (payload.length == 2) {
            this.timeout = payload[0];
            this.pollingMode = payload[1];
        } else if (payload.length == 1) {
            this.timeout = payload[0];
            this.pollingMode = (byte)2;
        } else {
            throw new MalformedPayloadException("Payload not sufficient length");
        }
    }

    public void setTimeout(byte timeout) {
        this.timeout = timeout;
    }

    public byte getTimeout() {
        return this.timeout;
    }

    public byte getPollingMode() {
        return this.pollingMode;
    }

    public void setPollingMode(byte pollingMode) {
        this.pollingMode = pollingMode;
    }

    @NonNull
    public byte[] getPayload() {
        return new byte[]{this.timeout, this.pollingMode};
    }
}

