/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.taptrack.tcmptappy2.CommandFamilyMessageResolver;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.TCMPMessage;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.AutoPollCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.AutoPollNdefCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.DispatchTagCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.DispatchTagsCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.EmulateCustomNdefRecordCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.EmulateTextRecordCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.EmulateUriRecordCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.GetBasicNfcLibraryVersionCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.LockTagCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.ScanNdefCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.ScanTagCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.StopCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.StreamNdefCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.StreamTagsCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.WriteNdefCustomMessageCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.WriteNdefTextRecordCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands.WriteNdefUriRecordCommand;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses.AutoPollTagEnteredResponse;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses.AutoPollTagExitedResponse;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses.BasicNfcErrorResponse;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses.BasicNfcLibraryVersionResponse;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses.EmulationStoppedResponse;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses.EmulationSuccessResponse;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses.NdefFoundResponse;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses.ScanTimeoutResponse;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses.SignedTagFoundResponse;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses.TagFoundResponse;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses.TagLockedResponse;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses.TagWrittenResponse;
import java.util.Arrays;

public class BasicNfcCommandResolver
implements CommandFamilyMessageResolver {
    public static final byte[] FAMILY_ID = new byte[]{0, 1};

    private static void assertFamilyMatches(@NonNull TCMPMessage message) {
        if (!Arrays.equals(message.getCommandFamily(), FAMILY_ID)) {
            throw new IllegalArgumentException("Specified message is for a different command family");
        }
    }

    @Nullable
    public TCMPMessage resolveCommand(@NonNull TCMPMessage message) throws MalformedPayloadException {
        AbstractBasicNfcMessage parsedMessage;
        BasicNfcCommandResolver.assertFamilyMatches(message);
        switch (message.getCommandCode()) {
            case -1: {
                parsedMessage = new GetBasicNfcLibraryVersionCommand();
                break;
            }
            case 4: {
                parsedMessage = new ScanNdefCommand();
                break;
            }
            case 2: {
                parsedMessage = new ScanTagCommand();
                break;
            }
            case 0: {
                parsedMessage = new StopCommand();
                break;
            }
            case 3: {
                parsedMessage = new StreamNdefCommand();
                break;
            }
            case 1: {
                parsedMessage = new StreamTagsCommand();
                break;
            }
            case 7: {
                parsedMessage = new WriteNdefCustomMessageCommand();
                break;
            }
            case 6: {
                parsedMessage = new WriteNdefTextRecordCommand();
                break;
            }
            case 5: {
                parsedMessage = new WriteNdefUriRecordCommand();
                break;
            }
            case 8: {
                parsedMessage = new LockTagCommand();
                break;
            }
            case 15: {
                parsedMessage = new DispatchTagCommand();
                break;
            }
            case 12: {
                parsedMessage = new DispatchTagsCommand();
                break;
            }
            case 16: {
                parsedMessage = new AutoPollCommand();
                break;
            }
            case 17: {
                parsedMessage = new AutoPollNdefCommand();
                break;
            }
            case 9: {
                parsedMessage = new EmulateTextRecordCommand();
                break;
            }
            case 10: {
                parsedMessage = new EmulateUriRecordCommand();
                break;
            }
            case 11: {
                parsedMessage = new EmulateCustomNdefRecordCommand();
                break;
            }
            default: {
                return null;
            }
        }
        parsedMessage.parsePayload(message.getPayload());
        return parsedMessage;
    }

    @Nullable
    public TCMPMessage resolveResponse(@NonNull TCMPMessage message) throws MalformedPayloadException {
        AbstractBasicNfcMessage parsedMessage;
        BasicNfcCommandResolver.assertFamilyMatches(message);
        switch (message.getCommandCode()) {
            case 127: {
                parsedMessage = new BasicNfcErrorResponse();
                break;
            }
            case 4: {
                parsedMessage = new BasicNfcLibraryVersionResponse();
                break;
            }
            case 2: {
                parsedMessage = new NdefFoundResponse();
                break;
            }
            case 3: {
                parsedMessage = new ScanTimeoutResponse();
                break;
            }
            case 1: {
                parsedMessage = new TagFoundResponse();
                break;
            }
            case 11: {
                parsedMessage = new SignedTagFoundResponse();
                break;
            }
            case 5: {
                parsedMessage = new TagWrittenResponse();
                break;
            }
            case 6: {
                parsedMessage = new TagLockedResponse();
                break;
            }
            case 12: {
                parsedMessage = new AutoPollTagEnteredResponse();
                break;
            }
            case 13: {
                parsedMessage = new AutoPollTagExitedResponse();
                break;
            }
            case 7: {
                parsedMessage = new EmulationSuccessResponse();
                break;
            }
            case 8: {
                parsedMessage = new EmulationStoppedResponse();
                break;
            }
            default: {
                return null;
            }
        }
        parsedMessage.parsePayload(message.getPayload());
        return parsedMessage;
    }

    @NonNull
    @Size(value=2L)
    public byte[] getCommandFamilyId() {
        return FAMILY_ID;
    }
}

