/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses;

import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.TlvParser;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SignedTagFoundResponse
extends AbstractBasicNfcMessage {
    public static final byte COMMAND_CODE = 11;
    private static final byte TAG_FOUND_TLV_TYPE = 1;
    byte[] mTagCode;
    byte mTagType;

    public SignedTagFoundResponse() {
        this.mTagCode = new byte[7];
        this.mTagType = 0;
    }

    public SignedTagFoundResponse(byte[] tagCode, byte tagType) {
        this.mTagCode = tagCode;
        this.mTagType = tagType;
    }

    public void parsePayload(byte[] payload) throws MalformedPayloadException {
        if (payload.length < 7) {
            throw new MalformedPayloadException();
        }
        try {
            List<TlvParser.Tlv> parsedTlvs = TlvParser.parseTlvsFromBinary(payload);
            if (parsedTlvs.size() == 0) {
                throw new MalformedPayloadException("No TLVs found in payload");
            }
            for (int i = 0; i < parsedTlvs.size(); ++i) {
                TlvParser.Tlv tlv = parsedTlvs.get(i);
                if (tlv.getType() != 1) continue;
                byte[] value = tlv.getValue();
                if (value.length < 5) {
                    throw new MalformedPayloadException("TLV too short to contain data");
                }
                this.mTagType = value[0];
                this.mTagCode = Arrays.copyOfRange(value, 1, value.length);
                return;
            }
            throw new MalformedPayloadException("Missing TLV in payload");
        }
        catch (IllegalArgumentException e) {
            throw new MalformedPayloadException((Throwable)e);
        }
    }

    public byte[] getTagCode() {
        return this.mTagCode;
    }

    public byte getTagType() {
        return this.mTagType;
    }

    public byte[] getPayload() {
        byte[] data = new byte[this.mTagCode.length + 1];
        data[0] = this.mTagType;
        System.arraycopy(this.mTagCode, 0, data, 1, this.mTagCode.length);
        TlvParser.Tlv tlv = new TlvParser.Tlv(1, data);
        return TlvParser.composeBinaryFromTlvs(Collections.singletonList(tlv));
    }

    public byte getCommandCode() {
        return 11;
    }
}

