/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands;

import android.nfc.FormatException;
import android.nfc.NdefMessage;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class WriteNdefCustomMessageCommand
extends AbstractBasicNfcMessage {
    public static final byte COMMAND_CODE = 7;
    protected byte timeout;
    protected byte lockflag;
    protected byte[] content;

    public WriteNdefCustomMessageCommand() {
        this.timeout = 0;
        this.lockflag = 0;
        this.content = new byte[0];
    }

    public WriteNdefCustomMessageCommand(byte timeout, boolean lockTag, byte[] content) {
        this.timeout = timeout;
        this.lockflag = (byte)(lockTag ? 1 : 0);
        this.content = content;
    }

    public WriteNdefCustomMessageCommand(byte timeout, byte lockTag, byte[] content) {
        this.timeout = timeout;
        this.lockflag = lockTag;
        this.content = content;
    }

    public WriteNdefCustomMessageCommand(byte timeout, byte lockTag, NdefMessage content) {
        this.timeout = timeout;
        this.lockflag = lockTag;
        this.content = content.toByteArray();
    }

    public void parsePayload(byte[] payload) throws MalformedPayloadException {
        if (payload.length >= 2) {
            this.timeout = payload[0];
            this.lockflag = payload[1];
            this.content = payload.length > 2 ? Arrays.copyOfRange(payload, 2, payload.length) : new byte[0];
        } else {
            throw new MalformedPayloadException("Invalid raw message");
        }
    }

    public byte getTimeout() {
        return this.timeout;
    }

    public void setTimeout(byte timeout) {
        this.timeout = timeout;
    }

    public byte getLockflag() {
        return this.lockflag;
    }

    public void setLockflag(byte lockflag) {
        this.lockflag = lockflag;
    }

    public byte[] getContentBytes() {
        return this.content;
    }

    public NdefMessage getContent() throws FormatException {
        if (this.content == null || this.content.length == 0) {
            return null;
        }
        return new NdefMessage(this.content);
    }

    public void setContent(NdefMessage content) {
        this.content = content.toByteArray();
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public boolean willLock() {
        return this.lockflag == 1;
    }

    public void setToLock(boolean lockTag) {
        this.lockflag = lockTag ? (byte)1 : 0;
    }

    public byte[] getPayload() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(3 + this.content.length);
        outputStream.write(this.timeout);
        outputStream.write(this.lockflag);
        try {
            outputStream.write(this.content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] result = outputStream.toByteArray();
        try {
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public byte getCommandCode() {
        return 7;
    }
}

