/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands;

import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;

public class AutoPollCommand
extends AbstractBasicNfcMessage {
    public static final byte COMMAND_CODE = 16;
    private byte scanModeIndicator;
    private byte heartBeatPeriod;
    private boolean buzzerDisabled;

    public AutoPollCommand() {
    }

    public AutoPollCommand(byte scanModeIndicator, byte heartbeatPeriod, boolean buzzerDisabled) {
        this.scanModeIndicator = scanModeIndicator;
        this.heartBeatPeriod = heartbeatPeriod;
        this.buzzerDisabled = buzzerDisabled;
    }

    public void parsePayload(byte[] payload) throws MalformedPayloadException {
        if (payload.length < 3) {
            throw new MalformedPayloadException("Invalid raw message");
        }
        this.scanModeIndicator = payload[0];
        this.heartBeatPeriod = payload[1];
        this.buzzerDisabled = payload[2] != 0;
    }

    public byte[] getPayload() {
        return new byte[]{this.scanModeIndicator, this.heartBeatPeriod, (byte)(this.buzzerDisabled ? 1 : 0)};
    }

    public byte getScanModeIndicator() {
        return this.scanModeIndicator;
    }

    public void setScanModeIndicator(byte scanModeIndicator) {
        this.scanModeIndicator = scanModeIndicator;
    }

    public byte getHeartBeatPeriod() {
        return this.heartBeatPeriod;
    }

    public void setHeartBeatPeriod(byte heartBeatPeriod) {
        this.heartBeatPeriod = heartBeatPeriod;
    }

    public boolean isBuzzerDisabled() {
        return this.buzzerDisabled;
    }

    public void setBuzzerDisabled(boolean buzzerDisabled) {
        this.buzzerDisabled = buzzerDisabled;
    }

    public byte getCommandCode() {
        return 16;
    }
}

