/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses;

import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;
import java.util.Arrays;

public class TagLockedResponse
extends AbstractBasicNfcMessage {
    public static final byte COMMAND_CODE = 6;
    byte[] tagCode;
    byte tagType;

    public TagLockedResponse() {
        this.tagCode = new byte[7];
        this.tagType = 0;
    }

    public TagLockedResponse(byte[] tagCode, byte tagType) {
        this.tagCode = tagCode;
        this.tagType = tagType;
    }

    public void parsePayload(byte[] payload) throws MalformedPayloadException {
        if (payload.length < 2) {
            throw new MalformedPayloadException("Payload too short to contain a tag locked response");
        }
        byte tagCodeLength = payload[1];
        if (2 + tagCodeLength < payload.length) {
            throw new MalformedPayloadException("Payload too short to contain tag code of length specified");
        }
        this.tagType = payload[0];
        this.tagCode = Arrays.copyOfRange(payload, 2, 2 + tagCodeLength);
    }

    public byte[] getTagCode() {
        return this.tagCode;
    }

    public void setTagCode(byte[] tagCode) {
        this.tagCode = tagCode;
    }

    public byte getTagType() {
        return this.tagType;
    }

    public void setTagType(byte tagType) {
        this.tagType = tagType;
    }

    public byte[] getPayload() {
        byte[] payload = new byte[this.tagCode.length + 2];
        payload[0] = this.tagType;
        payload[1] = (byte)this.tagCode.length;
        System.arraycopy(this.tagCode, 0, payload, 2, this.tagCode.length);
        return payload;
    }

    public byte getCommandCode() {
        return 6;
    }
}

