/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands;

import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class WriteNdefUriRecordCommand
extends AbstractBasicNfcMessage {
    public static final byte COMMAND_CODE = 5;
    protected byte timeout;
    protected byte lockflag;
    protected byte uriCode;
    protected byte[] uri;

    public WriteNdefUriRecordCommand() {
        this.timeout = 0;
        this.lockflag = 0;
        this.uriCode = 0;
        this.uri = new byte[0];
    }

    public WriteNdefUriRecordCommand(byte timeout, boolean lockTag, byte uriCode, byte[] uri) {
        this.timeout = timeout;
        this.lockflag = (byte)(lockTag ? 1 : 0);
        this.uri = uri;
        this.uriCode = uriCode;
    }

    public WriteNdefUriRecordCommand(byte timeout, byte lockflag, byte uriCode, byte[] uri) {
        this.timeout = timeout;
        this.lockflag = lockflag;
        this.uriCode = uriCode;
        this.uri = uri;
    }

    public WriteNdefUriRecordCommand(byte timeout, boolean lockflag, byte uriCode, String uri) {
        this(timeout, lockflag, uriCode, uri.getBytes());
    }

    public void parsePayload(byte[] payload) throws MalformedPayloadException {
        if (payload.length >= 3) {
            this.timeout = payload[0];
            this.lockflag = payload[1];
            this.uriCode = payload[2];
            this.uri = payload.length > 3 ? Arrays.copyOfRange(payload, 3, payload.length) : new byte[0];
        } else {
            throw new MalformedPayloadException("Invalid raw message");
        }
    }

    public byte getTimeout() {
        return this.timeout;
    }

    public void setTimeout(byte timeout) {
        this.timeout = timeout;
    }

    public byte getLockflag() {
        return this.lockflag;
    }

    public void setLockflag(byte lockflag) {
        this.lockflag = lockflag;
    }

    public boolean willLock() {
        return this.lockflag == 1;
    }

    public void setToLock(boolean lockTag) {
        this.lockflag = lockTag ? (byte)1 : 0;
    }

    public byte[] getUriBytes() {
        return this.uri;
    }

    public String getUri() {
        return new String(this.uri);
    }

    public void setUri(byte[] uri) {
        this.uri = uri;
    }

    public void setUri(String uri) {
        this.uri = uri.getBytes();
    }

    public byte getUriCode() {
        return this.uriCode;
    }

    public void setUriCode(byte uriCode) {
        this.uriCode = uriCode;
    }

    public byte[] getPayload() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(3 + this.uri.length);
        outputStream.write(this.timeout);
        outputStream.write(this.lockflag);
        outputStream.write(this.uriCode);
        try {
            outputStream.write(this.uri);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] result = outputStream.toByteArray();
        try {
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public byte getCommandCode() {
        return 5;
    }
}

