/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc.commands;

import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class WriteNdefTextRecordCommand
extends AbstractBasicNfcMessage {
    public static final byte COMMAND_CODE = 6;
    protected byte timeout;
    protected byte lockflag;
    protected byte[] text;

    public WriteNdefTextRecordCommand() {
        this.timeout = 0;
        this.lockflag = 0;
        this.text = new byte[0];
    }

    public WriteNdefTextRecordCommand(byte timeout, boolean lockTag, byte[] text) {
        this.timeout = timeout;
        this.lockflag = (byte)(lockTag ? 1 : 0);
        this.text = text;
    }

    public WriteNdefTextRecordCommand(byte timeout, byte lockTag, byte[] text) {
        this.timeout = timeout;
        this.lockflag = lockTag;
        this.text = text;
    }

    public WriteNdefTextRecordCommand(byte timeout, byte lockTag, String text) {
        this(timeout, lockTag, text.getBytes());
    }

    public void parsePayload(byte[] payload) throws MalformedPayloadException {
        if (payload.length >= 2) {
            this.timeout = payload[0];
            this.lockflag = payload[1];
            this.text = payload.length > 2 ? Arrays.copyOfRange(payload, 2, payload.length) : new byte[0];
        } else {
            throw new MalformedPayloadException("Invalid raw message");
        }
    }

    public byte getTimeout() {
        return this.timeout;
    }

    public void setTimeout(byte timeout) {
        this.timeout = timeout;
    }

    public byte getLockflag() {
        return this.lockflag;
    }

    public void setLockflag(byte lockflag) {
        this.lockflag = lockflag;
    }

    public boolean willLock() {
        return this.lockflag == 1;
    }

    public void setToLock(boolean lockTag) {
        this.lockflag = lockTag ? (byte)1 : 0;
    }

    public byte[] getTextBytes() {
        return this.text;
    }

    public String getText() {
        return new String(this.text);
    }

    public void setText(byte[] text) {
        this.text = text;
    }

    public void setText(String text) {
        try {
            this.text = text.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public byte[] getPayload() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(3 + this.text.length);
        outputStream.write(this.timeout);
        outputStream.write(this.lockflag);
        try {
            outputStream.write(this.text);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] result = outputStream.toByteArray();
        try {
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public byte getCommandCode() {
        return 6;
    }
}

