/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy2.commandfamilies.basicnfc.responses;

import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import com.taptrack.tcmptappy2.MalformedPayloadException;
import com.taptrack.tcmptappy2.commandfamilies.basicnfc.AbstractBasicNfcMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class NdefFoundResponse
extends AbstractBasicNfcMessage {
    public static final byte COMMAND_CODE = 2;
    byte[] tagCode;
    byte tagType;
    NdefMessage message;

    public NdefFoundResponse() {
        this.tagCode = new byte[7];
        this.message = new NdefMessage(new NdefRecord(0, null, null, null), new NdefRecord[0]);
        this.tagType = 0;
    }

    public NdefFoundResponse(byte[] tagCode, byte tagType, NdefMessage message) {
        this.tagCode = tagCode;
        this.tagType = tagType;
        this.message = message;
    }

    public byte[] getTagCode() {
        return this.tagCode;
    }

    public void setTagCode(byte[] tagCode) {
        this.tagCode = tagCode;
    }

    public byte getTagType() {
        return this.tagType;
    }

    public void setTagType(byte tagType) {
        this.tagType = tagType;
    }

    public NdefMessage getMessage() {
        return this.message;
    }

    public void setMessage(NdefMessage message) {
        this.message = message;
    }

    public void parsePayload(byte[] payload) throws MalformedPayloadException {
        if (payload.length < 2) {
            throw new MalformedPayloadException("No control bytes");
        }
        this.tagType = payload[0];
        byte tagCodeLength = (byte)(payload[1] & 0xFF);
        this.tagCode = Arrays.copyOfRange(payload, 2, tagCodeLength + 2);
        byte[] ndefMessage = new byte[payload.length - (tagCodeLength + 2)];
        if (payload.length > (tagCodeLength & 0xFF) + 2) {
            System.arraycopy(payload, tagCodeLength + 2, ndefMessage, 0, payload.length - tagCodeLength - 2);
        }
        if (ndefMessage.length != 0) {
            try {
                this.message = new NdefMessage(ndefMessage);
            }
            catch (FormatException e) {
                e.printStackTrace();
                throw new MalformedPayloadException("Bad Ndef Format");
            }
        } else {
            this.message = new NdefMessage(new NdefRecord(0, null, null, null), new NdefRecord[0]);
        }
    }

    public byte[] getPayload() {
        byte[] messageBytes = this.message.toByteArray();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(2 + this.tagCode.length + messageBytes.length);
        outputStream.write(this.tagType);
        outputStream.write(this.tagCode.length);
        try {
            outputStream.write(this.tagCode);
            outputStream.write(messageBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] result = outputStream.toByteArray();
        try {
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public byte getCommandCode() {
        return 2;
    }
}

