/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy.tcmp;

import com.taptrack.tcmptappy.tcmp.MalformedPayloadException;
import com.taptrack.tcmptappy.tcmp.MessageGarbledException;
import com.taptrack.tcmptappy.tcmp.TCMPMessage;
import com.taptrack.tcmptappy.tcmp.TCMPMessageParseException;

public class RawTCMPMessage
extends TCMPMessage {
    protected byte[] mPayload;
    protected byte[] mFamily;
    protected byte mCommand;

    public RawTCMPMessage(byte[] message) throws TCMPMessageParseException {
        try {
            if (TCMPMessage.validate(message)) {
                this.mFamily = new byte[]{message[3], message[4]};
                this.mCommand = message[5];
                int length = message.length - 8;
                this.mPayload = new byte[length];
                System.arraycopy(message, 6, this.mPayload, 0, length);
            }
        }
        catch (MessageGarbledException e) {
            e.printStackTrace();
            throw new TCMPMessageParseException("Unable to parse, invalid TCMPMessage format", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new TCMPMessageParseException("Unable to parse, invalid TCMPMessage format", e);
        }
    }

    @Override
    public void parsePayload(byte[] payload) throws MalformedPayloadException {
        this.mPayload = payload;
    }

    @Override
    public byte[] getPayload() {
        return this.mPayload;
    }

    @Override
    public byte getCommandCode() {
        return this.mCommand;
    }

    @Override
    public byte[] getCommandFamily() {
        return this.mFamily;
    }
}

