/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy.commlink;

import com.taptrack.tcmptappy.commlink.TcmpMessageListener;
import com.taptrack.tcmptappy.tcmp.MalformedPayloadException;
import com.taptrack.tcmptappy.tcmp.TCMPMessage;
import com.taptrack.tcmptappy.tcmp.common.CommandCodeNotSupportedException;
import com.taptrack.tcmptappy.tcmp.common.CommandFamilyMessageResolver;
import com.taptrack.tcmptappy.tcmp.common.FamilyCodeNotSupportedException;
import com.taptrack.tcmptappy.tcmp.common.ResponseCodeNotSupportedException;
import java.util.concurrent.atomic.AtomicReference;

public class TcmpResolverListener
implements TcmpMessageListener {
    private CommandFamilyMessageResolver resolver;
    private int mode;
    public static final int MODE_RECEIVED_MESSAGES = 0;
    public static final int MODE_SENT_MESSAGES = 1;
    private AtomicReference<TcmpMessageListener> resolvedListener = new AtomicReference();

    public TcmpResolverListener(CommandFamilyMessageResolver resolver, int mode) {
        if (resolver == null) {
            throw new NullPointerException("Cant use a null resolver!");
        }
        this.resolver = resolver;
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("mode must be one of MODE_RECEIVED_MESSAGES or MODE_SENT_MESSAGES");
        }
        this.mode = mode;
    }

    public void registerNextListener(TcmpMessageListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cant set a null resolver!");
        }
        this.resolvedListener.set(listener);
    }

    public void unregisterNextListener() {
        this.resolvedListener.set(null);
    }

    @Override
    public void onNewTcmpMessage(TCMPMessage tcmpMessage) {
        TcmpMessageListener target = this.resolvedListener.get();
        if (target != null) {
            if (this.mode == 1) {
                try {
                    target.onNewTcmpMessage(this.resolver.parseCommand(tcmpMessage));
                }
                catch (MalformedPayloadException | CommandCodeNotSupportedException | FamilyCodeNotSupportedException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    target.onNewTcmpMessage(this.resolver.parseResponse(tcmpMessage));
                }
                catch (MalformedPayloadException | FamilyCodeNotSupportedException | ResponseCodeNotSupportedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

