/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy.tcmp.common;

import com.taptrack.tcmptappy.tcmp.MalformedPayloadException;
import com.taptrack.tcmptappy.tcmp.TCMPMessage;
import com.taptrack.tcmptappy.tcmp.common.CommandCodeNotSupportedException;
import com.taptrack.tcmptappy.tcmp.common.CommandFamily;
import com.taptrack.tcmptappy.tcmp.common.FamilyCodeNotSupportedException;
import com.taptrack.tcmptappy.tcmp.common.ResponseCodeNotSupportedException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CommandFamilyMessageResolver {
    private final Map<WrappedCommandFamilyId, CommandFamily> libraries = new ConcurrentHashMap<WrappedCommandFamilyId, CommandFamily>(2);
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public void registerCommandLibrary(CommandFamily newLibrary) {
        this.registerCommandLibrary(newLibrary, false);
    }

    public void registerCommandLibrary(CommandFamily newLibrary, boolean overwriteExisting) {
        if (newLibrary == null) {
            throw new NullPointerException();
        }
        byte[] familyId = newLibrary.getCommandFamilyId();
        WrappedCommandFamilyId wrappedId = new WrappedCommandFamilyId(familyId);
        if (this.libraries.containsKey(wrappedId) && !overwriteExisting) {
            throw new IllegalArgumentException("A command family has already been registered with that command code");
        }
        this.libraries.put(wrappedId, newLibrary);
    }

    private CommandFamily getCommandLibraryForMessage(TCMPMessage message) throws FamilyCodeNotSupportedException {
        if (message.getCommandFamily() == null) {
            throw new IllegalArgumentException("Must have a command family");
        }
        WrappedCommandFamilyId wrappedId = new WrappedCommandFamilyId(message.getCommandFamily());
        CommandFamily lib = this.libraries.get(wrappedId);
        if (lib == null) {
            throw new FamilyCodeNotSupportedException(String.format("No command library found for family code %s", CommandFamilyMessageResolver.bytesToHex(message.getCommandFamily())));
        }
        return lib;
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public TCMPMessage parseCommand(TCMPMessage message) throws FamilyCodeNotSupportedException, CommandCodeNotSupportedException, MalformedPayloadException {
        if (message == null) {
            throw new NullPointerException();
        }
        CommandFamily commandFamily = this.getCommandLibraryForMessage(message);
        return commandFamily.parseCommand(message);
    }

    public TCMPMessage parseResponse(TCMPMessage message) throws FamilyCodeNotSupportedException, ResponseCodeNotSupportedException, MalformedPayloadException {
        if (message == null) {
            throw new NullPointerException();
        }
        CommandFamily commandFamily = this.getCommandLibraryForMessage(message);
        return commandFamily.parseResponse(message);
    }

    private static class WrappedCommandFamilyId {
        private final byte[] familyId;

        public WrappedCommandFamilyId(byte[] familyId) {
            if (familyId == null) {
                throw new NullPointerException();
            }
            this.familyId = familyId;
        }

        public int hashCode() {
            return Arrays.hashCode(this.familyId);
        }

        public boolean equals(Object obj) {
            if (obj instanceof WrappedCommandFamilyId) {
                return Arrays.equals(this.familyId, ((WrappedCommandFamilyId)obj).familyId);
            }
            return false;
        }
    }
}

