/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy.blescannercompat.scanners.lollipop;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import com.taptrack.tcmptappy.blescannercompat.ScanFilter;
import com.taptrack.tcmptappy.blescannercompat.ScanRecord;
import com.taptrack.tcmptappy.blescannercompat.ScanResult;
import com.taptrack.tcmptappy.blescannercompat.ScanSettings;
import java.util.ArrayList;
import java.util.List;

public class LollipopUtils {
    @TargetApi(value=21)
    public static int convertNativeStatusToCompat(int nativeStatus) {
        switch (nativeStatus) {
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
        }
        return 1;
    }

    @TargetApi(value=21)
    public static ScanResult convertNativeResultToCompat(android.bluetooth.le.ScanResult nativeResult) {
        BluetoothDevice device = nativeResult.getDevice();
        int rssi = nativeResult.getRssi();
        long timestampNanos = nativeResult.getTimestampNanos();
        ScanRecord compatRecord = LollipopUtils.convertNativeRecordToCompat(nativeResult.getScanRecord());
        return new ScanResult(device, compatRecord, rssi, timestampNanos);
    }

    @TargetApi(value=21)
    public static ScanRecord convertNativeRecordToCompat(android.bluetooth.le.ScanRecord nativeRecord) {
        return ScanRecord.parseFromBytes(nativeRecord.getBytes());
    }

    @TargetApi(value=21)
    public static List<ScanResult> convertNativeResultListToCompat(List<android.bluetooth.le.ScanResult> nativeResults) {
        ArrayList<ScanResult> compatResults = new ArrayList<ScanResult>(nativeResults.size());
        for (android.bluetooth.le.ScanResult nativeResult : nativeResults) {
            compatResults.add(LollipopUtils.convertNativeResultToCompat(nativeResult));
        }
        return compatResults;
    }

    @TargetApi(value=21)
    public static int convertNativeScanFailedErrorCodeToCompat(int nativeCode) {
        switch (nativeCode) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
        }
        return 3;
    }

    @TargetApi(value=21)
    public static android.bluetooth.le.ScanSettings convertCompatScanSettingsToNative(ScanSettings compatSettings) {
        if (compatSettings == null) {
            return null;
        }
        ScanSettings.Builder nativeBuilder = new ScanSettings.Builder();
        nativeBuilder = nativeBuilder.setReportDelay(compatSettings.getReportDelayMillis());
        switch (compatSettings.getScanMode()) {
            case 1: {
                nativeBuilder = nativeBuilder.setScanMode(1);
                break;
            }
            case 2: {
                nativeBuilder = nativeBuilder.setScanMode(1);
                break;
            }
            default: {
                nativeBuilder = nativeBuilder.setScanMode(1);
            }
        }
        return nativeBuilder.build();
    }

    @TargetApi(value=21)
    public static List<android.bluetooth.le.ScanFilter> convertCompatScanFilterListToNative(List<ScanFilter> compatFilters) {
        if (compatFilters == null) {
            return null;
        }
        ArrayList<android.bluetooth.le.ScanFilter> nativeFilters = new ArrayList<android.bluetooth.le.ScanFilter>(compatFilters.size());
        for (ScanFilter compatFilter : compatFilters) {
            nativeFilters.add(LollipopUtils.convertCompatScanFilterToNative(compatFilter));
        }
        return nativeFilters;
    }

    @TargetApi(value=21)
    public static android.bluetooth.le.ScanFilter convertCompatScanFilterToNative(ScanFilter compatFilter) {
        if (compatFilter == null) {
            return null;
        }
        ScanFilter.Builder nativeBuilder = new ScanFilter.Builder();
        if (compatFilter.getDeviceAddress() != null) {
            nativeBuilder = nativeBuilder.setDeviceAddress(compatFilter.getDeviceAddress());
        }
        if (compatFilter.getDeviceName() != null) {
            nativeBuilder = nativeBuilder.setDeviceAddress(compatFilter.getDeviceName());
        }
        if (compatFilter.getManufacturerData() != null && compatFilter.getManufacturerId() != -1) {
            nativeBuilder = compatFilter.getManufacturerDataMask() != null ? nativeBuilder.setManufacturerData(compatFilter.getManufacturerId(), compatFilter.getManufacturerData(), compatFilter.getManufacturerDataMask()) : nativeBuilder.setManufacturerData(compatFilter.getManufacturerId(), compatFilter.getManufacturerData());
        }
        if (compatFilter.getServiceDataUuid() != null && compatFilter.getServiceData() != null) {
            nativeBuilder = compatFilter.getServiceDataMask() != null ? nativeBuilder.setServiceData(compatFilter.getServiceDataUuid(), compatFilter.getServiceData(), compatFilter.getServiceDataMask()) : nativeBuilder.setServiceData(compatFilter.getServiceDataUuid(), compatFilter.getServiceData());
        }
        if (compatFilter.getServiceUuid() != null) {
            nativeBuilder = compatFilter.getServiceUuidMask() != null ? nativeBuilder.setServiceUuid(compatFilter.getServiceUuid(), compatFilter.getServiceUuidMask()) : nativeBuilder.setServiceUuid(compatFilter.getServiceUuid());
        }
        return nativeBuilder.build();
    }
}

