/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy.blescannercompat.scanners.lollipop;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.taptrack.tcmptappy.blescannercompat.BluetoothLeScannerCompat;
import com.taptrack.tcmptappy.blescannercompat.IBluetoothLeScanner;
import com.taptrack.tcmptappy.blescannercompat.ScanCallback;
import com.taptrack.tcmptappy.blescannercompat.ScanFilter;
import com.taptrack.tcmptappy.blescannercompat.ScanResult;
import com.taptrack.tcmptappy.blescannercompat.ScanSettings;
import com.taptrack.tcmptappy.blescannercompat.scanners.ScannerUtils;
import com.taptrack.tcmptappy.blescannercompat.scanners.lollipop.LollipopUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@TargetApi(value=21)
public class LollipopBleScanner
extends BluetoothLeScannerCompat
implements IBluetoothLeScanner {
    private final BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    private final Map<ScanCallback, ScanCallbackHolder> callbackHolderMap = new ConcurrentHashMap<ScanCallback, ScanCallbackHolder>();

    protected void throwIfCallbackInUse(ScanCallback callback) {
        if (this.callbackHolderMap.containsKey(callback)) {
            throw new IllegalArgumentException("Scan already initiated for that callback");
        }
    }

    protected BluetoothLeScanner getNativeScannerOrThrow() {
        BluetoothLeScanner scanner = this.bluetoothAdapter.getBluetoothLeScanner();
        if (scanner == null) {
            throw new IllegalStateException("Could not get scanner");
        }
        return scanner;
    }

    @Override
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public void startScan(@NonNull ScanCallback callback) {
        ScannerUtils.throwOnAdaptorNotEnabled(this.bluetoothAdapter);
        BluetoothLeScanner nativeScanner = this.getNativeScannerOrThrow();
        this.throwIfCallbackInUse(callback);
        ScanCallbackHolder holder = new ScanCallbackHolder(callback);
        this.callbackHolderMap.put(callback, holder);
        nativeScanner.startScan(holder.getNativeCallback());
    }

    @Override
    public void startScan(List<ScanFilter> filters, @NonNull ScanSettings settings, @NonNull ScanCallback callback) {
        ScannerUtils.throwOnAdaptorNotEnabled(this.bluetoothAdapter);
        BluetoothLeScanner nativeScanner = this.getNativeScannerOrThrow();
        this.throwIfCallbackInUse(callback);
        ScanCallbackHolder holder = new ScanCallbackHolder(callback, settings, filters);
        nativeScanner.startScan(holder.getNativeFilters(), holder.getNativeScanSettings(), holder.getNativeCallback());
    }

    @Override
    public void stopScan(@NonNull ScanCallback callback) {
        ScanCallbackHolder holder = this.callbackHolderMap.get(callback);
        if (holder == null) {
            return;
        }
        BluetoothLeScanner scanner = this.getNativeScannerOrThrow();
        scanner.stopScan(holder.getNativeCallback());
        this.callbackHolderMap.remove(callback);
    }

    @Override
    public void flushPendingScanResults(@NonNull ScanCallback callback) {
        ScannerUtils.throwOnAdaptorNotEnabled(this.bluetoothAdapter);
        BluetoothLeScanner nativeScanner = this.getNativeScannerOrThrow();
        ScanCallbackHolder holder = this.callbackHolderMap.get(callback);
        if (holder == null) {
            throw new IllegalArgumentException("Callback not registered");
        }
        nativeScanner.flushPendingScanResults(holder.getNativeCallback());
    }

    private class ScanCallbackHolder {
        private ScanCallback compatCallback;
        private ScanSettings compatSettings;
        private List<ScanFilter> compatFilters;
        private android.bluetooth.le.ScanCallback nativeCallback;
        private android.bluetooth.le.ScanSettings nativeSettings;
        private List<android.bluetooth.le.ScanFilter> nativeFilters;

        public ScanCallbackHolder(ScanCallback compatCallback) {
            this.compatCallback = compatCallback;
            this.compatFilters = new ArrayList<ScanFilter>(0);
            this.createNatives();
        }

        public ScanCallbackHolder(ScanCallback compatCallback, ScanSettings compatSettings, List<ScanFilter> compatFilters) {
            this.compatCallback = compatCallback;
            this.compatSettings = compatSettings;
            this.compatFilters = compatFilters;
            this.createNatives();
        }

        private void createNatives() {
            this.nativeCallback = new android.bluetooth.le.ScanCallback(){

                public void onScanResult(int callbackType, android.bluetooth.le.ScanResult result) {
                    super.onScanResult(callbackType, result);
                    int convertedType = LollipopUtils.convertNativeStatusToCompat(callbackType);
                    ScanResult convertedResult = LollipopUtils.convertNativeResultToCompat(result);
                    ScanCallbackHolder.this.compatCallback.onScanResult(convertedType, convertedResult);
                }

                public void onBatchScanResults(List<android.bluetooth.le.ScanResult> results) {
                    super.onBatchScanResults(results);
                    ScanCallbackHolder.this.compatCallback.onBatchScanResults(LollipopUtils.convertNativeResultListToCompat(results));
                }

                public void onScanFailed(int errorCode) {
                    super.onScanFailed(errorCode);
                    ScanCallbackHolder.this.compatCallback.onScanFailed(LollipopUtils.convertNativeScanFailedErrorCodeToCompat(errorCode));
                }
            };
            this.nativeFilters = LollipopUtils.convertCompatScanFilterListToNative(this.compatFilters);
            this.nativeSettings = LollipopUtils.convertCompatScanSettingsToNative(this.compatSettings);
        }

        public android.bluetooth.le.ScanCallback getNativeCallback() {
            return this.nativeCallback;
        }

        public android.bluetooth.le.ScanSettings getNativeScanSettings() {
            return this.nativeSettings;
        }

        public List<android.bluetooth.le.ScanFilter> getNativeFilters() {
            return this.nativeFilters;
        }
    }
}

