/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy.blescannercompat.scanners.jellybean;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.taptrack.tcmptappy.blescannercompat.IBluetoothLeScanner;
import com.taptrack.tcmptappy.blescannercompat.ScanCallback;
import com.taptrack.tcmptappy.blescannercompat.ScanFilter;
import com.taptrack.tcmptappy.blescannercompat.ScanRecord;
import com.taptrack.tcmptappy.blescannercompat.ScanResult;
import com.taptrack.tcmptappy.blescannercompat.ScanSettings;
import com.taptrack.tcmptappy.blescannercompat.scanners.ScannerUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@TargetApi(value=16)
public class JellybeanBleScanner
implements IBluetoothLeScanner,
BluetoothAdapter.LeScanCallback {
    protected final BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    protected final Map<ScanCallback, ScanCallbackHolder> callbackHolderMap = new ConcurrentHashMap<ScanCallback, ScanCallbackHolder>();

    protected void throwIfCallbackInUse(ScanCallback callback) {
        if (this.callbackHolderMap.containsKey(callback)) {
            throw new IllegalArgumentException("Scan already initiated for that callback");
        }
    }

    protected void updateScanningStatus() {
        if (this.callbackHolderMap.isEmpty()) {
            this.bluetoothAdapter.stopLeScan((BluetoothAdapter.LeScanCallback)this);
        } else {
            this.bluetoothAdapter.startLeScan((BluetoothAdapter.LeScanCallback)this);
        }
    }

    @Override
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public void startScan(@NonNull ScanCallback callback) {
        ScannerUtils.throwOnAdaptorNotEnabled(this.bluetoothAdapter);
        this.throwIfCallbackInUse(callback);
        this.callbackHolderMap.put(callback, new ScanCallbackHolder(callback));
        this.updateScanningStatus();
    }

    @Override
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public void startScan(List<ScanFilter> filters, @NonNull ScanSettings settings, @NonNull ScanCallback callback) {
        ScannerUtils.throwOnAdaptorNotEnabled(this.bluetoothAdapter);
        this.throwIfCallbackInUse(callback);
        this.callbackHolderMap.put(callback, new ScanCallbackHolder(callback, settings, filters));
        this.updateScanningStatus();
    }

    @Override
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public void stopScan(@NonNull ScanCallback callback) {
        this.callbackHolderMap.remove(callback);
        this.updateScanningStatus();
    }

    @Override
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public void flushPendingScanResults(@NonNull ScanCallback callback) {
        ScannerUtils.throwOnAdaptorNotEnabled(this.bluetoothAdapter);
        this.throwIfCallbackInUse(callback);
        ScanCallbackHolder holder = this.callbackHolderMap.get(callback);
        holder.flushPendingResults();
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        ScanRecord compatRecord = ScanRecord.parseFromBytes(scanRecord);
        ScanResult compatResult = new ScanResult(device, compatRecord, rssi, SystemClock.elapsedRealtimeNanos());
        Collection<ScanCallbackHolder> holders = this.callbackHolderMap.values();
        for (ScanCallbackHolder holder : holders) {
            holder.handleScanResult(compatResult);
        }
    }

    private class ScanCallbackHolder {
        private ScanCallback compatScanner;
        private ScanSettings compatSettings;
        private List<ScanFilter> compatFilters;

        public ScanCallbackHolder(ScanCallback compatScanner) {
            this.compatScanner = compatScanner;
        }

        public ScanCallbackHolder(ScanCallback compatScanner, ScanSettings compatSettings, List<ScanFilter> compatFilters) {
            this.compatScanner = compatScanner;
            this.compatSettings = compatSettings;
            this.compatFilters = compatFilters;
        }

        public void handleScanResult(ScanResult result) {
            if (this.compatFilters == null || this.compatFilters.size() == 0) {
                this.handleFilteredResult(result);
            }
            for (ScanFilter filter : this.compatFilters) {
                if (!filter.matches(result)) continue;
                this.handleFilteredResult(result);
                break;
            }
        }

        private void handleFilteredResult(ScanResult result) {
            this.compatScanner.onScanResult(2, result);
        }

        public void flushPendingResults() {
        }
    }
}

