/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy.blescannercompat;

import android.os.ParcelUuid;
import android.support.annotation.Nullable;
import android.util.Log;
import com.taptrack.tcmptappy.blescannercompat.BluetoothUuid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ScanRecord {
    private static final String TAG = "ScanRecord";
    private static final int DATA_TYPE_FLAGS = 1;
    private static final int DATA_TYPE_SERVICE_UUIDS_16_BIT_PARTIAL = 2;
    private static final int DATA_TYPE_SERVICE_UUIDS_16_BIT_COMPLETE = 3;
    private static final int DATA_TYPE_SERVICE_UUIDS_32_BIT_PARTIAL = 4;
    private static final int DATA_TYPE_SERVICE_UUIDS_32_BIT_COMPLETE = 5;
    private static final int DATA_TYPE_SERVICE_UUIDS_128_BIT_PARTIAL = 6;
    private static final int DATA_TYPE_SERVICE_UUIDS_128_BIT_COMPLETE = 7;
    private static final int DATA_TYPE_LOCAL_NAME_SHORT = 8;
    private static final int DATA_TYPE_LOCAL_NAME_COMPLETE = 9;
    private static final int DATA_TYPE_TX_POWER_LEVEL = 10;
    private static final int DATA_TYPE_SERVICE_DATA = 22;
    private static final int DATA_TYPE_MANUFACTURER_SPECIFIC_DATA = 255;
    private final int mAdvertiseFlags;
    @Nullable
    private final List<ParcelUuid> mServiceUuids;
    private final int mManufacturerId;
    @Nullable
    private final byte[] mManufacturerSpecificData;
    @Nullable
    private final ParcelUuid mServiceDataUuid;
    @Nullable
    private final byte[] mServiceData;
    private final int mTxPowerLevel;
    private final String mDeviceName;
    private final byte[] mBytes;

    public int getAdvertiseFlags() {
        return this.mAdvertiseFlags;
    }

    public List<ParcelUuid> getServiceUuids() {
        return this.mServiceUuids;
    }

    public int getManufacturerId() {
        return this.mManufacturerId;
    }

    public byte[] getManufacturerSpecificData() {
        return this.mManufacturerSpecificData;
    }

    public ParcelUuid getServiceDataUuid() {
        return this.mServiceDataUuid;
    }

    public byte[] getServiceData() {
        return this.mServiceData;
    }

    public int getTxPowerLevel() {
        return this.mTxPowerLevel;
    }

    @Nullable
    public String getDeviceName() {
        return this.mDeviceName;
    }

    public byte[] getBytes() {
        return this.mBytes;
    }

    private ScanRecord(List<ParcelUuid> serviceUuids, ParcelUuid serviceDataUuid, byte[] serviceData, int manufacturerId, byte[] manufacturerSpecificData, int advertiseFlags, int txPowerLevel, String localName, byte[] bytes) {
        this.mServiceUuids = serviceUuids;
        this.mManufacturerId = manufacturerId;
        this.mManufacturerSpecificData = manufacturerSpecificData;
        this.mServiceDataUuid = serviceDataUuid;
        this.mServiceData = serviceData;
        this.mDeviceName = localName;
        this.mAdvertiseFlags = advertiseFlags;
        this.mTxPowerLevel = txPowerLevel;
        this.mBytes = bytes;
    }

    public static ScanRecord parseFromBytes(byte[] scanRecord) {
        if (scanRecord == null) {
            return null;
        }
        int advertiseFlag = -1;
        ArrayList<ParcelUuid> serviceUuids = new ArrayList<ParcelUuid>();
        String localName = null;
        int txPowerLevel = Integer.MIN_VALUE;
        ParcelUuid serviceDataUuid = null;
        byte[] serviceData = null;
        int manufacturerId = -1;
        byte[] manufacturerSpecificData = null;
        try {
            int length;
            int dataLength;
            block12: for (int currentPos = 0; currentPos < scanRecord.length && (length = scanRecord[currentPos++] & 0xFF) != 0; currentPos += dataLength) {
                dataLength = length - 1;
                int fieldType = scanRecord[currentPos++] & 0xFF;
                switch (fieldType) {
                    case 1: {
                        advertiseFlag = scanRecord[currentPos] & 0xFF;
                        continue block12;
                    }
                    case 2: 
                    case 3: {
                        ScanRecord.parseServiceUuid(scanRecord, currentPos, dataLength, 2, serviceUuids);
                        continue block12;
                    }
                    case 4: 
                    case 5: {
                        ScanRecord.parseServiceUuid(scanRecord, currentPos, dataLength, 4, serviceUuids);
                        continue block12;
                    }
                    case 6: 
                    case 7: {
                        ScanRecord.parseServiceUuid(scanRecord, currentPos, dataLength, 16, serviceUuids);
                        continue block12;
                    }
                    case 8: 
                    case 9: {
                        localName = new String(ScanRecord.extractBytes(scanRecord, currentPos, dataLength));
                        continue block12;
                    }
                    case 10: {
                        txPowerLevel = scanRecord[currentPos];
                        continue block12;
                    }
                    case 22: {
                        serviceData = ScanRecord.extractBytes(scanRecord, currentPos, dataLength);
                        int serviceUuidLength = 2;
                        byte[] serviceDataUuidBytes = ScanRecord.extractBytes(scanRecord, currentPos, serviceUuidLength);
                        serviceDataUuid = BluetoothUuid.parseUuidFrom(serviceDataUuidBytes);
                        continue block12;
                    }
                    case 255: {
                        manufacturerSpecificData = ScanRecord.extractBytes(scanRecord, currentPos, dataLength);
                        manufacturerId = ((manufacturerSpecificData[1] & 0xFF) << 8) + (manufacturerSpecificData[0] & 0xFF);
                        continue block12;
                    }
                }
            }
            if (serviceUuids.isEmpty()) {
                serviceUuids = null;
            }
            return new ScanRecord(serviceUuids, serviceDataUuid, serviceData, manufacturerId, manufacturerSpecificData, advertiseFlag, txPowerLevel, localName, scanRecord);
        }
        catch (IndexOutOfBoundsException e) {
            Log.e((String)TAG, (String)("unable to parse scan record: " + Arrays.toString(scanRecord)));
            return null;
        }
    }

    public String toString() {
        return "ScanRecord [mAdvertiseFlags=" + this.mAdvertiseFlags + ", mServiceUuids=" + this.mServiceUuids + ", mManufacturerId=" + this.mManufacturerId + ", mManufacturerSpecificData=" + Arrays.toString(this.mManufacturerSpecificData) + ", mServiceDataUuid=" + this.mServiceDataUuid + ", mServiceData=" + Arrays.toString(this.mServiceData) + ", mTxPowerLevel=" + this.mTxPowerLevel + ", mDeviceName=" + this.mDeviceName + "]";
    }

    private static int parseServiceUuid(byte[] scanRecord, int currentPos, int dataLength, int uuidLength, List<ParcelUuid> serviceUuids) {
        while (dataLength > 0) {
            byte[] uuidBytes = ScanRecord.extractBytes(scanRecord, currentPos, uuidLength);
            serviceUuids.add(BluetoothUuid.parseUuidFrom(uuidBytes));
            dataLength -= uuidLength;
            currentPos += uuidLength;
        }
        return currentPos;
    }

    private static byte[] extractBytes(byte[] scanRecord, int start, int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(scanRecord, start, bytes, 0, length);
        return bytes;
    }
}

