/*
 * Decompiled with CFR 0.152.
 */
package com.taptrack.tcmptappy.blescannercompat;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.taptrack.tcmptappy.blescannercompat.IBluetoothLeScanner;
import com.taptrack.tcmptappy.blescannercompat.scanners.jellybean.JellybeanBleScanner;
import com.taptrack.tcmptappy.blescannercompat.scanners.lollipop.LollipopBleScanner;

public abstract class BluetoothLeScannerCompat {
    private static IBluetoothLeScanner scannerImpl;
    private static final Object scannerLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public static IBluetoothLeScanner getBluetoothLeScanner() {
        Object object = scannerLock;
        synchronized (object) {
            if (scannerImpl == null) {
                if (Build.VERSION.SDK_INT >= 21) {
                    scannerImpl = new LollipopBleScanner();
                } else if (Build.VERSION.SDK_INT >= 16) {
                    scannerImpl = new JellybeanBleScanner();
                }
            }
        }
        if (scannerImpl == null) {
            throw new IllegalStateException("This device has a version of Android that is too old to support BLE");
        }
        return scannerImpl;
    }

    static {
        scannerLock = new Object();
    }
}

