/*
 * Decompiled with CFR 0.152.
 */
package com.tapjoy.mraid.controller;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.CalendarContract;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import android.widget.ListAdapter;
import android.widget.SimpleAdapter;
import android.widget.Toast;
import com.tapjoy.TapjoyLog;
import com.tapjoy.mraid.controller.Abstract;
import com.tapjoy.mraid.controller.Assets;
import com.tapjoy.mraid.controller.Display;
import com.tapjoy.mraid.controller.MraidLocation;
import com.tapjoy.mraid.controller.MraidSensor;
import com.tapjoy.mraid.controller.Network;
import com.tapjoy.mraid.view.MraidView;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=14)
public class Utility
extends Abstract {
    private Assets c;
    private Display d;
    private MraidLocation e;
    private Network f;
    private MraidSensor g;

    public Utility(MraidView adView, Context context) {
        super(adView, context);
        this.c = new Assets(adView, context);
        this.d = new Display(adView, context);
        this.e = new MraidLocation(adView, context);
        this.f = new Network(adView, context);
        this.g = new MraidSensor(adView, context);
        adView.addJavascriptInterface(this.c, "MRAIDAssetsControllerBridge");
        adView.addJavascriptInterface(this.d, "MRAIDDisplayControllerBridge");
        adView.addJavascriptInterface(this.e, "MRAIDLocationControllerBridge");
        adView.addJavascriptInterface(this.f, "MRAIDNetworkControllerBridge");
        adView.addJavascriptInterface(this.g, "MRAIDSensorControllerBridge");
    }

    public void init(float density) {
        StringBuilder stringBuilder = new StringBuilder("window.mraidview.fireChangeEvent({ state: 'default', network: '").append(this.f.getNetwork()).append("', size: ").append(this.d.getSize()).append(", placement: '").append((Object)this.a.getPlacementType()).append("', maxSize: ").append(this.d.getMaxSize()).append(",expandProperties: ").append(this.d.getMaxSize()).append(", screenSize: ").append(this.d.getScreenSize()).append(", defaultPosition: { x:").append((int)((float)this.a.getLeft() / density)).append(", y: ").append((int)((float)this.a.getTop() / density)).append(", width: ").append((int)((float)this.a.getWidth() / density)).append(", height: ").append((int)((float)this.a.getHeight() / density)).append(" }, orientation:").append(this.d.getOrientation()).append(",");
        Utility utility = this;
        String string2 = "supports: [ 'level-1', 'level-2', 'screen', 'orientation', 'network'";
        if (utility.e.allowLocationServices() && (utility.b.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0 || utility.b.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0)) {
            string2 = string2 + ", 'location'";
        }
        if (utility.b.checkCallingOrSelfPermission("android.permission.SEND_SMS") == 0) {
            string2 = string2 + ", 'sms'";
        }
        if (utility.b.checkCallingOrSelfPermission("android.permission.CALL_PHONE") == 0) {
            string2 = string2 + ", 'phone'";
        }
        if (utility.b.checkCallingOrSelfPermission("android.permission.WRITE_CALENDAR") == 0 && utility.b.checkCallingOrSelfPermission("android.permission.READ_CALENDAR") == 0 && Build.VERSION.SDK_INT >= 14) {
            string2 = string2 + ", 'calendar'";
        }
        string2 = string2 + ", 'video'";
        string2 = string2 + ", 'audio'";
        string2 = string2 + ", 'map'";
        string2 = string2 + ", 'email' ]";
        TapjoyLog.d("MRAID Utility", "getSupports: " + string2);
        String string3 = stringBuilder.append(string2).append(",viewable:true });").toString();
        TapjoyLog.d("MRAID Utility", "init: injection: " + string3);
        this.a.injectMraidJavaScript(string3);
        this.fireReadyEvent();
        this.fireViewableChange(true);
    }

    public void fireReadyEvent() {
        this.a.injectMraidJavaScript("mraid.signalReady();");
    }

    public void fireViewableChange(boolean visible) {
        this.a.injectMraidJavaScript("window.mraidview.fireChangeEvent({viewable:" + visible + "});");
    }

    @JavascriptInterface
    public void sendSMS(String recipient, String body) {
        TapjoyLog.d("MRAID Utility", "sendSMS: recipient: " + recipient + " body: " + body);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.putExtra("address", recipient);
        intent.putExtra("sms_body", body);
        intent.setType("vnd.android-dir/mms-sms");
        intent.addFlags(0x10000000);
        this.b.startActivity(intent);
    }

    @JavascriptInterface
    public void sendMail(String recipient, String subject, String body) {
        TapjoyLog.d("MRAID Utility", "sendMail: recipient: " + recipient + " subject: " + subject + " body: " + body);
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("plain/text");
        intent.putExtra("android.intent.extra.EMAIL", new String[]{recipient});
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.putExtra("android.intent.extra.TEXT", body);
        intent.addFlags(0x10000000);
        this.b.startActivity(intent);
    }

    @JavascriptInterface
    public void makeCall(String number) {
        String string2;
        String string3;
        TapjoyLog.d("MRAID Utility", "makeCall: number: " + number);
        String string4 = number;
        if (TextUtils.isEmpty((CharSequence)string4)) {
            string3 = null;
        } else {
            StringBuilder stringBuilder = new StringBuilder("tel:");
            stringBuilder.append(string4);
            string3 = string2 = stringBuilder.toString();
        }
        if (string3 == null) {
            this.a.raiseError("Bad Phone Number", "makeCall");
            return;
        }
        Intent intent = new Intent("android.intent.action.CALL", Uri.parse((String)string2.toString()));
        intent.addFlags(0x10000000);
        this.b.startActivity(intent);
    }

    @JavascriptInterface
    public void mraidCreateEvent(String properties) {
        JSONObject jSONObject;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (Build.VERSION.SDK_INT < 14) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        try {
            jSONObject = new JSONObject(properties);
            JSONObject jSONObject2 = jSONObject.getJSONObject("start");
            JSONObject jSONObject3 = jSONObject.optJSONObject("end");
            if (jSONObject3 == null) {
                jSONObject3 = jSONObject2;
            }
            string2 = jSONObject.getString("description");
            string3 = jSONObject.optString("location");
            string4 = jSONObject.optString("summary");
            string5 = jSONObject.optString("status");
            calendar.set(jSONObject2.getInt("year"), jSONObject2.getInt("month"), jSONObject2.getInt("day"), jSONObject2.getInt("hour"), jSONObject2.getInt("min"));
            calendar2.set(jSONObject3.getInt("year"), jSONObject3.getInt("month"), jSONObject3.getInt("day"), jSONObject3.getInt("hour"), jSONObject3.getInt("min"));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        jSONObject = new Intent("android.intent.action.INSERT").setData(CalendarContract.Events.CONTENT_URI).putExtra("beginTime", calendar.getTimeInMillis()).putExtra("endTime", calendar2.getTimeInMillis()).putExtra("title", string4).putExtra("description", string2).putExtra("eventLocation", string3).putExtra("eventStatus", string5);
        this.a.getContext().startActivity((Intent)jSONObject);
    }

    @JavascriptInterface
    public void createEvent(final String date, final String title, final String body) {
        TapjoyLog.d("MRAID Utility", "createEvent: date: " + date + " title: " + title + " body: " + body);
        ContentResolver contentResolver = this.b.getContentResolver();
        String[] stringArray = new String[]{"_id", "displayName", "_sync_account"};
        Cursor cursor = Integer.parseInt(Build.VERSION.SDK) == 8 ? contentResolver.query(Uri.parse((String)"content://com.android.calendar/calendars"), stringArray, null, null, null) : contentResolver.query(Uri.parse((String)"content://calendar/calendars"), stringArray, null, null, null);
        if (cursor == null || cursor != null && !cursor.moveToFirst()) {
            Toast.makeText((Context)this.b, (CharSequence)"No calendar account found", (int)1).show();
            if (cursor != null) {
                cursor.close();
            }
            return;
        }
        if (cursor.getCount() == 1) {
            this.a(cursor.getInt(0), date, title, body);
        } else {
            SimpleAdapter simpleAdapter;
            final ArrayList<SimpleAdapter> arrayList = new ArrayList<SimpleAdapter>();
            for (int i2 = 0; i2 < cursor.getCount(); ++i2) {
                simpleAdapter = new HashMap();
                simpleAdapter.put("ID", cursor.getString(0));
                simpleAdapter.put("NAME", cursor.getString(1));
                simpleAdapter.put("EMAILID", cursor.getString(2));
                arrayList.add(simpleAdapter);
                cursor.moveToNext();
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(this.b);
            builder.setTitle((CharSequence)"Choose Calendar to save event to");
            simpleAdapter = new SimpleAdapter(this.b, arrayList, 17367053, new String[]{"NAME", "EMAILID"}, new int[]{16908308, 16908309});
            builder.setSingleChoiceItems((ListAdapter)simpleAdapter, -1, new DialogInterface.OnClickListener(){

                public final void onClick(DialogInterface dialog, int which) {
                    Map map = (Map)arrayList.get(which);
                    Utility.this.a(Integer.parseInt((String)map.get("ID")), date, title, body);
                    dialog.cancel();
                }
            });
            builder.create().show();
        }
        cursor.close();
    }

    private void a(int n2, String string2, String string3, String string4) {
        ContentResolver contentResolver = this.b.getContentResolver();
        long l2 = Long.parseLong(string2);
        long l3 = l2 + 3600000L;
        ContentValues contentValues = new ContentValues();
        contentValues.put("calendar_id", Integer.valueOf(n2));
        contentValues.put("title", string3);
        contentValues.put("description", string4);
        contentValues.put("dtstart", Long.valueOf(l2));
        contentValues.put("hasAlarm", Integer.valueOf(1));
        contentValues.put("dtend", Long.valueOf(l3));
        Uri uri = Integer.parseInt(Build.VERSION.SDK) == 8 ? contentResolver.insert(Uri.parse((String)"content://com.android.calendar/events"), contentValues) : contentResolver.insert(Uri.parse((String)"content://calendar/events"), contentValues);
        if (uri != null) {
            long l4 = Long.parseLong(uri.getLastPathSegment());
            ContentValues contentValues2 = new ContentValues();
            contentValues2.put("event_id", Long.valueOf(l4));
            contentValues2.put("method", Integer.valueOf(1));
            contentValues2.put("minutes", Integer.valueOf(15));
            if (Integer.parseInt(Build.VERSION.SDK) == 8) {
                contentResolver.insert(Uri.parse((String)"content://com.android.calendar/reminders"), contentValues2);
            } else {
                contentResolver.insert(Uri.parse((String)"content://calendar/reminders"), contentValues2);
            }
        }
        Toast.makeText((Context)this.b, (CharSequence)"Event added to calendar", (int)0).show();
    }

    public String copyTextFromJarIntoAssetDir(String alias, String source) {
        return this.c.copyTextFromJarIntoAssetDir(alias, source);
    }

    public void setMaxSize(int w2, int h2) {
        this.d.setMaxSize(w2, h2);
    }

    public String writeToDiskWrap(InputStream is2, String currentFile, boolean storeInHashedDirectory, String injection, String bridgePath) {
        return this.c.writeToDiskWrap(is2, currentFile, storeInHashedDirectory, injection, bridgePath);
    }

    @JavascriptInterface
    public void activate(String event) {
        TapjoyLog.d("MRAID Utility", "activate: " + event);
        if (event.equalsIgnoreCase("networkChange")) {
            this.f.startNetworkListener();
            return;
        }
        if (this.e.allowLocationServices() && event.equalsIgnoreCase("locationChange")) {
            this.e.startLocationListener();
            return;
        }
        if (event.equalsIgnoreCase("shake")) {
            this.g.startShakeListener();
            return;
        }
        if (event.equalsIgnoreCase("tiltChange")) {
            this.g.startTiltListener();
            return;
        }
        if (event.equalsIgnoreCase("headingChange")) {
            this.g.startHeadingListener();
            return;
        }
        if (event.equalsIgnoreCase("orientationChange")) {
            this.d.startConfigurationListener();
        }
    }

    @JavascriptInterface
    public void deactivate(String event) {
        TapjoyLog.d("MRAID Utility", "deactivate: " + event);
        if (event.equalsIgnoreCase("networkChange")) {
            this.f.stopNetworkListener();
            return;
        }
        if (event.equalsIgnoreCase("locationChange")) {
            this.e.stopAllListeners();
            return;
        }
        if (event.equalsIgnoreCase("shake")) {
            this.g.stopShakeListener();
            return;
        }
        if (event.equalsIgnoreCase("tiltChange")) {
            this.g.stopTiltListener();
            return;
        }
        if (event.equalsIgnoreCase("headingChange")) {
            this.g.stopHeadingListener();
            return;
        }
        if (event.equalsIgnoreCase("orientationChange")) {
            this.d.stopConfigurationListener();
        }
    }

    public void deleteOldAds() {
        this.c.deleteOldAds();
    }

    @Override
    public void stopAllListeners() {
        try {
            this.c.stopAllListeners();
            this.d.stopAllListeners();
            this.e.stopAllListeners();
            this.f.stopAllListeners();
            this.g.stopAllListeners();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @JavascriptInterface
    public void showAlert(String message) {
        TapjoyLog.e("MRAID Utility", message);
    }
}

