/*
 * Decompiled with CFR 0.152.
 */
package com.tapjoy.internal;

import android.util.Base64;
import com.tapjoy.internal.lx;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import java.util.zip.CRC32;

public class ApiKeyDecoded {
    private final String a;
    private final int b;
    private final KeyUsage c;
    private final String d;
    private final String e;
    private final String f;

    public ApiKeyDecoded(String apiKey) {
        byte[] byArray;
        int n2 = apiKey.length();
        if (!apiKey.matches("[A-Za-z0-9\\-_]*") || n2 < 60 || (n2 & 3) != 0) {
            throw new IllegalArgumentException("The given API key was malformed.");
        }
        try {
            byArray = Base64.decode((String)apiKey, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("The given API key was malformed.", illegalArgumentException);
        }
        int n3 = byArray.length;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        int n4 = byArray.length - 4;
        int n5 = byteBuffer.getInt(n4);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, n4);
        int n6 = (int)cRC32.getValue();
        if (n5 != n6) {
            throw new IllegalArgumentException("The given API key was invalid.");
        }
        this.a = apiKey;
        this.d = new UUID(byteBuffer.getLong(0), byteBuffer.getLong(8)).toString();
        this.b = byteBuffer.get(16);
        this.c = KeyUsage.valueOf(byteBuffer.get(17));
        this.e = apiKey.substring(24, 44);
        if (this.b == 1) {
            this.f = null;
            return;
        }
        if (this.b == 2 && this.c == KeyUsage.SDK_ANDROID) {
            if (n3 < 57) {
                throw new IllegalArgumentException("The given API key was invalid.");
            }
            byte[] byArray2 = new byte[12];
            System.arraycopy(byArray, 33, byArray2, 0, 12);
            this.f = new String(lx.a(byArray2));
            return;
        }
        throw new IllegalArgumentException("The given API key was not supported.");
    }

    public boolean equals(Object o2) {
        if (o2 instanceof ApiKeyDecoded) {
            return this.a.equals(((ApiKeyDecoded)o2).a);
        }
        return false;
    }

    public String toString() {
        return this.a;
    }

    public String getAppId() {
        return this.d;
    }

    public String getSecretKey() {
        return this.e;
    }

    public KeyUsage getKeyUsage() {
        return this.c;
    }

    public String getAnalyticsId() {
        return this.f;
    }

    public static String get5RocksAppId(String uuid) {
        if (uuid.regionMatches(13, "-8000-8000-", 0, 11)) {
            return new StringBuffer().append(uuid.substring(0, 8)).append(uuid.substring(24, 30)).append(uuid.substring(9, 13)).append(uuid.substring(30)).toString();
        }
        throw new IllegalArgumentException("The given UUID did not come from 5Rocks.");
    }

    public static enum KeyUsage {
        SDK_ANDROID(2),
        RPC_ANALYTICS(49);

        public byte id;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private KeyUsage() {
            void id2;
            this.id = id2;
        }

        public static KeyUsage valueOf(byte id2) {
            for (KeyUsage keyUsage : KeyUsage.values()) {
                if (keyUsage.id != id2) continue;
                return keyUsage;
            }
            return null;
        }
    }
}

