/*
 * Decompiled with CFR 0.152.
 */
package com.tapjoy;

import com.tapjoy.TapjoyHttpURLResponse;
import com.tapjoy.TapjoyLog;
import com.tapjoy.TapjoyUtil;
import com.tapjoy.http.HttpClientCentral;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class TapjoyURLConnection {
    public static final int TYPE_GET = 0;
    public static final int TYPE_POST = 1;

    public TapjoyHttpURLResponse getRedirectFromURL(String url) {
        return this.getResponseFromURL(url, "", 0, true, null, null, null);
    }

    public TapjoyHttpURLResponse getResponseFromURL(String url, Map params) {
        return this.getResponseFromURL(url, TapjoyUtil.convertURLParams(params, false), 0);
    }

    public TapjoyHttpURLResponse getResponseFromURL(String url, Map params, int type) {
        return this.getResponseFromURL(url, TapjoyUtil.convertURLParams(params, false), type);
    }

    public TapjoyHttpURLResponse getResponseFromURL(String url) {
        return this.getResponseFromURL(url, "", 0);
    }

    public TapjoyHttpURLResponse getResponseFromURL(String url, String params) {
        return this.getResponseFromURL(url, params, 0);
    }

    public TapjoyHttpURLResponse getResponseFromURL(String url, String params, int type) {
        return this.getResponseFromURL(url, params, type, false, null, null, null);
    }

    public TapjoyHttpURLResponse getResponseFromURL(String url, Map params, Map headers, Map postParams) {
        return this.getResponseFromURL(url, params != null ? TapjoyUtil.convertURLParams(params, false) : "", 1, false, headers, "application/x-www-form-urlencoded", TapjoyUtil.convertURLParams(postParams, false));
    }

    public TapjoyHttpURLResponse getResponseFromURL(String url, Map params, Map headers, String postJsonData) {
        return this.getResponseFromURL(url, params != null ? TapjoyUtil.convertURLParams(params, false) : "", 1, false, headers, "application/json;charset=utf-8", postJsonData);
    }

    public TapjoyHttpURLResponse getResponseFromURL(String url, String params, int type, boolean getRedirectOnly, Map headers, String postContentType, String postContent) {
        TapjoyHttpURLResponse tapjoyHttpURLResponse = new TapjoyHttpURLResponse();
        HttpURLConnection httpURLConnection = null;
        BufferedReader bufferedReader = null;
        try {
            Object object;
            String string = url + params;
            TapjoyLog.i("TapjoyURLConnection", "http " + (type == 0 ? "get" : "post") + ": " + string);
            httpURLConnection = (HttpURLConnection)HttpClientCentral.openConnection(new URL(string));
            if (getRedirectOnly) {
                httpURLConnection.setInstanceFollowRedirects(false);
            }
            httpURLConnection.setConnectTimeout(15000);
            httpURLConnection.setReadTimeout(30000);
            if (headers != null) {
                object = headers.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = object.next();
                    httpURLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (type == 1) {
                httpURLConnection.setRequestMethod("POST");
                if (postContent != null) {
                    TapjoyLog.i("TapjoyURLConnection", "Content-Type: " + postContentType);
                    TapjoyLog.i("TapjoyURLConnection", "Content:");
                    TapjoyLog.i("TapjoyURLConnection", postContent);
                    httpURLConnection.setRequestProperty("Content-Type", postContentType);
                    httpURLConnection.setRequestProperty("Connection", "close");
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setFixedLengthStreamingMode(postContent.length());
                    object = new OutputStreamWriter(httpURLConnection.getOutputStream());
                    ((Writer)object).write(postContent);
                    ((OutputStreamWriter)object).close();
                }
            }
            httpURLConnection.connect();
            tapjoyHttpURLResponse.statusCode = httpURLConnection.getResponseCode();
            tapjoyHttpURLResponse.headerFields = httpURLConnection.getHeaderFields();
            tapjoyHttpURLResponse.date = httpURLConnection.getDate();
            tapjoyHttpURLResponse.expires = httpURLConnection.getExpiration();
            if (!getRedirectOnly) {
                bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            }
            if (!getRedirectOnly) {
                String string2;
                StringBuilder stringBuilder = new StringBuilder();
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string2 + '\n');
                }
                tapjoyHttpURLResponse.response = stringBuilder.toString();
            }
            if (tapjoyHttpURLResponse.statusCode == 302) {
                tapjoyHttpURLResponse.redirectURL = httpURLConnection.getHeaderField("Location");
            }
            if ((object = httpURLConnection.getHeaderField("content-length")) != null) {
                try {
                    tapjoyHttpURLResponse.contentLength = Integer.valueOf((String)object);
                }
                catch (Exception exception) {
                    TapjoyLog.e("TapjoyURLConnection", "Exception: " + exception.toString());
                }
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            httpURLConnection = null;
        }
        catch (Exception exception) {
            TapjoyLog.e("TapjoyURLConnection", "Exception: " + exception.toString());
            try {
                if (httpURLConnection != null && tapjoyHttpURLResponse.response == null) {
                    String string;
                    bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string + '\n');
                    }
                    tapjoyHttpURLResponse.response = stringBuilder.toString();
                }
            }
            catch (Exception exception2) {
                TapjoyLog.e("TapjoyURLConnection", "Exception trying to get error code/content: " + exception2.toString());
            }
        }
        TapjoyLog.i("TapjoyURLConnection", "--------------------");
        TapjoyLog.i("TapjoyURLConnection", "response status: " + tapjoyHttpURLResponse.statusCode);
        TapjoyLog.i("TapjoyURLConnection", "response size: " + tapjoyHttpURLResponse.contentLength);
        if (tapjoyHttpURLResponse.redirectURL != null && tapjoyHttpURLResponse.redirectURL.length() > 0) {
            TapjoyLog.i("TapjoyURLConnection", "redirectURL: " + tapjoyHttpURLResponse.redirectURL);
        }
        TapjoyLog.i("TapjoyURLConnection", "--------------------");
        return tapjoyHttpURLResponse;
    }

    public String getContentLength(String url) {
        String string = null;
        try {
            String string2 = url.replaceAll(" ", "%20");
            TapjoyLog.d("TapjoyURLConnection", "requestURL: " + string2);
            HttpURLConnection httpURLConnection = (HttpURLConnection)HttpClientCentral.openConnection(new URL(string2));
            httpURLConnection.setConnectTimeout(15000);
            httpURLConnection.setReadTimeout(30000);
            string = httpURLConnection.getHeaderField("content-length");
        }
        catch (Exception exception) {
            TapjoyLog.e("TapjoyURLConnection", "Exception: " + exception.toString());
        }
        TapjoyLog.d("TapjoyURLConnection", "content-length: " + string);
        return string;
    }
}

