/*
 * Decompiled with CFR 0.152.
 */
package com.tapjoy;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;
import android.text.TextUtils;
import com.tapjoy.TJCacheListener;
import com.tapjoy.TapjoyCacheMap;
import com.tapjoy.TapjoyCachedAssetData;
import com.tapjoy.TapjoyErrorMessage;
import com.tapjoy.TapjoyLog;
import com.tapjoy.TapjoyUtil;
import com.tapjoy.http.HttpClientCentral;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TapjoyCache {
    public static final String CACHE_DIRECTORY_NAME = "Tapjoy/Cache/";
    public static boolean unit_test_mode = false;
    private static TapjoyCache a = null;
    private Context b;
    private TapjoyCacheMap c;
    private Vector d;
    private ExecutorService e;
    public static final int CACHE_LIMIT = -1;
    private File f;

    public TapjoyCache(Context applicationContext) {
        if (a == null || unit_test_mode) {
            a = this;
            this.b = applicationContext;
            this.c = new TapjoyCacheMap(applicationContext, -1);
            this.d = new Vector();
            this.e = Executors.newFixedThreadPool(5);
            TapjoyCache tapjoyCache = this;
            if (Environment.getExternalStorageDirectory() != null) {
                TapjoyUtil.deleteFileOrDirectory(new File(Environment.getExternalStorageDirectory(), "tapjoy"));
                TapjoyUtil.deleteFileOrDirectory(new File(Environment.getExternalStorageDirectory(), "tjcache/tmp/"));
            }
            tapjoyCache.f = new File(tapjoyCache.b.getFilesDir() + "/Tapjoy/Cache/");
            if (!tapjoyCache.f.exists()) {
                if (tapjoyCache.f.mkdirs()) {
                    TapjoyLog.d("TapjoyCache", "Created directory at: " + tapjoyCache.f.getPath());
                } else {
                    TapjoyLog.e("TapjoyCache", "Error initalizing cache");
                    a = null;
                }
            }
            tapjoyCache.a();
        }
    }

    private void a() {
        SharedPreferences sharedPreferences = this.b.getSharedPreferences("tapjoyCacheData", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        for (Map.Entry entry : sharedPreferences.getAll().entrySet()) {
            File file = new File((String)entry.getKey());
            if (file.exists() && file.isFile()) {
                TapjoyCachedAssetData tapjoyCachedAssetData = TapjoyCachedAssetData.fromRawJSONString(entry.getValue().toString());
                if (tapjoyCachedAssetData != null) {
                    TapjoyLog.d("TapjoyCache", "Loaded Asset: " + tapjoyCachedAssetData.getAssetURL());
                    String string = TapjoyCache.b(tapjoyCachedAssetData.getAssetURL());
                    if (string != null && !"".equals(string) && string.length() > 0) {
                        if (tapjoyCachedAssetData.getTimeOfDeathInSeconds() < System.currentTimeMillis() / 1000L) {
                            TapjoyLog.d("TapjoyCache", "Asset expired, removing from cache: " + tapjoyCachedAssetData.getAssetURL());
                            if (tapjoyCachedAssetData.getLocalFilePath() == null || tapjoyCachedAssetData.getLocalFilePath().length() <= 0) continue;
                            TapjoyUtil.deleteFileOrDirectory(new File(tapjoyCachedAssetData.getLocalFilePath()));
                            continue;
                        }
                        this.c.put(string, tapjoyCachedAssetData);
                        continue;
                    }
                    TapjoyLog.e("TapjoyCache", "Removing asset because deserialization failed.");
                    editor.remove((String)entry.getKey()).commit();
                    continue;
                }
                TapjoyLog.e("TapjoyCache", "Removing asset because deserialization failed.");
                editor.remove((String)entry.getKey()).commit();
                continue;
            }
            TapjoyLog.d("TapjoyCache", "Removing reference to missing asset: " + (String)entry.getKey());
            editor.remove((String)entry.getKey()).commit();
        }
    }

    public void cacheAssetGroup(final JSONArray assetGroup, final TJCacheListener tapjoyCacheListener) {
        if (assetGroup != null && assetGroup.length() > 0) {
            new Thread(){

                @Override
                public final void run() {
                    TapjoyLog.d("TapjoyCache", "Starting to cache asset group size of " + assetGroup.length());
                    ArrayList<Future> arrayList = new ArrayList<Future>();
                    int n2 = 1;
                    for (int i2 = 0; i2 < assetGroup.length(); ++i2) {
                        try {
                            JSONObject object = assetGroup.getJSONObject(i2);
                            Future executionException = TapjoyCache.this.cacheAssetFromJSONObject(object);
                            if (executionException == null) continue;
                            arrayList.add(executionException);
                            continue;
                        }
                        catch (JSONException jSONException) {
                            TapjoyLog.e("TapjoyCache", "Failed to load JSON object from JSONArray");
                        }
                    }
                    for (Future future : arrayList) {
                        try {
                            if (((Boolean)future.get()).booleanValue()) continue;
                            n2 = 2;
                        }
                        catch (InterruptedException interruptedException) {
                            TapjoyLog.e("TapjoyCache", "Caching thread failed: " + interruptedException.toString());
                            n2 = 2;
                        }
                        catch (ExecutionException executionException) {
                            TapjoyLog.e("TapjoyCache", "Caching thread failed: " + executionException.toString());
                            n2 = 2;
                        }
                    }
                    TapjoyLog.d("TapjoyCache", "Finished caching group");
                    if (tapjoyCacheListener != null) {
                        tapjoyCacheListener.onCachingComplete(n2);
                    }
                }
            }.start();
            return;
        }
        if (tapjoyCacheListener != null) {
            tapjoyCacheListener.onCachingComplete(1);
        }
    }

    public Future cacheAssetFromJSONObject(JSONObject assetData) {
        try {
            String string = assetData.getString("url");
            Long.valueOf(86400L);
            String string2 = assetData.optString("offerId");
            Long l2 = assetData.optLong("timeToLive");
            return this.cacheAssetFromURL(string, string2, l2);
        }
        catch (JSONException jSONException) {
            TapjoyLog.e("TapjoyCache", "Required parameters to cache an asset from JSON is not present");
            return null;
        }
    }

    public Future cacheAssetFromURL(String assetURLString, String offerId, long timeToLive) {
        URL uRL;
        try {
            uRL = new URL(assetURLString);
        }
        catch (MalformedURLException malformedURLException) {
            TapjoyLog.d("TapjoyCache", "Invalid cache assetURL");
            return null;
        }
        String string = TapjoyCache.b(assetURLString);
        if (this.d.contains(string)) {
            TapjoyLog.d("TapjoyCache", "URL is already in the process of being cached: " + assetURLString);
            return null;
        }
        return this.startCachingThread(uRL, offerId, timeToLive);
    }

    private static String b(String string) {
        if (string.startsWith("//")) {
            string = "http:" + string;
        }
        try {
            return new URL(string).getFile();
        }
        catch (MalformedURLException malformedURLException) {
            TapjoyLog.e("TapjoyCache", "Invalid URL " + string);
            return "";
        }
    }

    public Future startCachingThread(URL assetURL, String offerId, long timeToLive) {
        if (assetURL != null) {
            return this.e.submit(new CacheAssetThread(assetURL, offerId, timeToLive));
        }
        return null;
    }

    public void clearTapjoyCache() {
        TapjoyLog.d("TapjoyCache", "Cleaning Tapjoy cache!");
        TapjoyUtil.deleteFileOrDirectory(this.f);
        if (this.f.mkdirs()) {
            TapjoyLog.d("TapjoyCache", "Created new cache directory at: " + this.f.getPath());
        }
        this.c = new TapjoyCacheMap(this.b, -1);
    }

    public boolean removeAssetFromCache(String url) {
        String string = TapjoyCache.b(url);
        return string != "" && this.c.remove(string) != null;
    }

    public boolean isURLDownloading(String url) {
        if (this.d != null) {
            String string = TapjoyCache.b(url);
            return string != "" && this.d.contains(string);
        }
        return false;
    }

    public boolean isURLCached(String url) {
        return this.c.get(TapjoyCache.b(url)) != null;
    }

    public TapjoyCachedAssetData getCachedDataForURL(String url) {
        String string = TapjoyCache.b(url);
        if (string != "") {
            return (TapjoyCachedAssetData)this.c.get(string);
        }
        return null;
    }

    public TapjoyCacheMap getCachedData() {
        return this.c;
    }

    public String getPathOfCachedURL(String url) {
        String string = TapjoyCache.b(url);
        if (string != "" && this.c.containsKey(string)) {
            TapjoyCachedAssetData tapjoyCachedAssetData = (TapjoyCachedAssetData)this.c.get(string);
            if (new File(tapjoyCachedAssetData.getLocalFilePath()).exists()) {
                url = tapjoyCachedAssetData.getLocalURL();
            } else {
                TapjoyCache.getInstance().removeAssetFromCache(url);
            }
        }
        return url;
    }

    public String cachedAssetsToJSON() {
        Iterator iterator = this.c.entrySet().iterator();
        JSONObject jSONObject = new JSONObject();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            try {
                jSONObject.put(((String)entry.getKey()).toString(), (Object)((TapjoyCachedAssetData)entry.getValue()).toRawJSONString());
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return jSONObject.toString();
    }

    public String getCachedOfferIDs() {
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.c != null) {
            Iterator iterator = this.c.entrySet().iterator();
            while (iterator.hasNext()) {
                String string2 = ((TapjoyCachedAssetData)iterator.next().getValue()).getOfferId();
                if (string2 == null || string2.length() == 0 || arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
            string = TextUtils.join((CharSequence)",", arrayList);
        }
        return string;
    }

    public void printCacheInformation() {
        TapjoyLog.d("TapjoyCache", "------------- Cache Data -------------");
        TapjoyLog.d("TapjoyCache", "Number of files in cache: " + this.c.size());
        TapjoyLog.d("TapjoyCache", "Cache Size: " + TapjoyUtil.fileOrDirectorySize(this.f));
        TapjoyLog.d("TapjoyCache", "--------------------------------------");
    }

    public static TapjoyCache getInstance() {
        return a;
    }

    public static void setInstance(TapjoyCache cache) {
        a = cache;
    }

    public class CacheAssetThread
    implements Callable {
        private URL b;
        private String c;
        private long d;

        public CacheAssetThread(URL assetURL, String offerId, long timeToLive) {
            this.b = assetURL;
            this.c = offerId;
            this.d = timeToLive;
            if (this.d <= 0L) {
                this.d = 86400L;
            }
            TapjoyCache.this.d.add(TapjoyCache.b(this.b.toString()));
        }

        /*
         * Loose catch block
         */
        public Boolean call() {
            Object object;
            File file;
            String string;
            block35: {
                string = TapjoyCache.b(this.b.toString());
                if (TapjoyCache.this.c.containsKey(string)) {
                    TapjoyCachedAssetData tapjoyCachedAssetData = (TapjoyCachedAssetData)TapjoyCache.this.c.get(string);
                    if (new File(tapjoyCachedAssetData.getLocalFilePath()).exists()) {
                        if (this.d != 0L) {
                            ((TapjoyCachedAssetData)TapjoyCache.this.c.get(string)).resetTimeToLive(this.d);
                        } else {
                            ((TapjoyCachedAssetData)TapjoyCache.this.c.get(string)).resetTimeToLive(86400L);
                        }
                        TapjoyLog.d("TapjoyCache", "Reseting time to live for " + this.b.toString());
                        TapjoyCache.this.d.remove(string);
                        return true;
                    }
                    TapjoyCache.getInstance().removeAssetFromCache(string);
                }
                System.currentTimeMillis();
                BufferedInputStream bufferedInputStream = null;
                FilterOutputStream filterOutputStream = null;
                try {
                    file = new File(TapjoyCache.this.f + "/" + TapjoyUtil.SHA256(string));
                }
                catch (Exception exception) {
                    TapjoyCache.this.d.remove(string);
                    return false;
                }
                TapjoyLog.d("TapjoyCache", "Downloading and caching asset from: " + this.b + " to " + file);
                object = HttpClientCentral.openConnection(this.b);
                ((URLConnection)object).setConnectTimeout(15000);
                ((URLConnection)object).setReadTimeout(30000);
                ((URLConnection)object).connect();
                bufferedInputStream = new BufferedInputStream(((URLConnection)object).getInputStream());
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                TapjoyUtil.writeFileToDevice(bufferedInputStream, filterOutputStream);
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
                break block35;
                catch (SocketTimeoutException socketTimeoutException) {
                    Boolean bl2;
                    block33: {
                        TapjoyLog.e("TapjoyCache", new TapjoyErrorMessage(TapjoyErrorMessage.ErrorType.NETWORK_ERROR, "Network timeout during caching: " + socketTimeoutException.toString()));
                        TapjoyCache.this.d.remove(string);
                        TapjoyUtil.deleteFileOrDirectory(file);
                        bl2 = false;
                        if (bufferedInputStream == null) break block33;
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (filterOutputStream != null) {
                        try {
                            filterOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return bl2;
                }
                catch (Exception exception) {
                    Boolean bl3;
                    block34: {
                        TapjoyLog.e("TapjoyCache", "Error caching asset: " + exception.toString());
                        TapjoyCache.this.d.remove(string);
                        TapjoyUtil.deleteFileOrDirectory(file);
                        bl3 = false;
                        if (bufferedInputStream == null) break block34;
                        {
                            catch (Throwable throwable) {
                                if (bufferedInputStream != null) {
                                    try {
                                        bufferedInputStream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                if (filterOutputStream != null) {
                                    try {
                                        filterOutputStream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                throw throwable;
                            }
                        }
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (filterOutputStream != null) {
                        try {
                            filterOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return bl3;
                }
            }
            object = new TapjoyCachedAssetData(this.b.toString(), file.getAbsolutePath(), this.d);
            if (this.c != null) {
                ((TapjoyCachedAssetData)object).setOfferID(this.c);
            }
            TapjoyCache.this.c.put(string, (TapjoyCachedAssetData)object);
            TapjoyCache.this.d.remove(string);
            TapjoyLog.d("TapjoyCache", "----- Download complete -----" + ((TapjoyCachedAssetData)object).toString());
            return true;
        }
    }
}

