/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachOperationFailedException;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import sun.tools.attach.HotSpotVirtualMachine;

public class BsdVirtualMachine
extends HotSpotVirtualMachine {
    private static final String tmpdir;
    String path;
    private static final String PROTOCOL_VERSION = "1";
    private static final int ATTACH_ERROR_BADVERSION = 101;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BsdVirtualMachine(AttachProvider provider, String vmid) throws AttachNotSupportedException, IOException {
        super(provider, vmid);
        int pid;
        try {
            pid = Integer.parseInt(vmid);
        }
        catch (NumberFormatException x) {
            throw new AttachNotSupportedException("Invalid process identifier");
        }
        this.path = this.findSocketFile(pid);
        if (this.path == null) {
            File f = new File(tmpdir, ".attach_pid" + pid);
            BsdVirtualMachine.createAttachFile(f.getPath());
            try {
                BsdVirtualMachine.sendQuitTo(pid);
                int i = 0;
                long delay = 200L;
                int retries = (int)(this.attachTimeout() / delay);
                do {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.path = this.findSocketFile(pid);
                } while (++i <= retries && this.path == null);
                if (this.path == null) {
                    throw new AttachNotSupportedException("Unable to open socket file: target process not responding or HotSpot VM not loaded");
                }
            }
            finally {
                f.delete();
            }
        }
        BsdVirtualMachine.checkPermissions(this.path);
        int s2 = BsdVirtualMachine.socket();
        try {
            BsdVirtualMachine.connect(s2, this.path);
        }
        finally {
            BsdVirtualMachine.close(s2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() throws IOException {
        BsdVirtualMachine bsdVirtualMachine = this;
        synchronized (bsdVirtualMachine) {
            if (this.path != null) {
                this.path = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream execute(String cmd, Object ... args2) throws AgentLoadException, IOException {
        int completionStatus;
        String p;
        assert (args2.length <= 3);
        BsdVirtualMachine bsdVirtualMachine = this;
        synchronized (bsdVirtualMachine) {
            if (this.path == null) {
                throw new IOException("Detached from target VM");
            }
            p = this.path;
        }
        int s2 = BsdVirtualMachine.socket();
        try {
            BsdVirtualMachine.connect(s2, p);
        }
        catch (IOException x) {
            BsdVirtualMachine.close(s2);
            throw x;
        }
        IOException ioe = null;
        try {
            this.writeString(s2, PROTOCOL_VERSION);
            this.writeString(s2, cmd);
            for (int i = 0; i < 3; ++i) {
                if (i < args2.length && args2[i] != null) {
                    this.writeString(s2, (String)args2[i]);
                    continue;
                }
                this.writeString(s2, "");
            }
        }
        catch (IOException x) {
            ioe = x;
        }
        SocketInputStream sis = new SocketInputStream(s2);
        try {
            completionStatus = this.readInt(sis);
        }
        catch (IOException x) {
            sis.close();
            if (ioe != null) {
                throw ioe;
            }
            throw x;
        }
        if (completionStatus != 0) {
            String message = this.readErrorMessage(sis);
            sis.close();
            if (completionStatus == 101) {
                throw new IOException("Protocol mismatch with target VM");
            }
            if (cmd.equals("load")) {
                throw new AgentLoadException("Failed to load agent library");
            }
            if (message == null) {
                throw new AttachOperationFailedException("Command failed in target VM");
            }
            throw new AttachOperationFailedException(message);
        }
        return sis;
    }

    private String findSocketFile(int pid) {
        String fn = ".java_pid" + pid;
        File f = new File(tmpdir, fn);
        return f.exists() ? f.getPath() : null;
    }

    private void writeString(int fd, String s2) throws IOException {
        byte[] b;
        if (s2.length() > 0) {
            try {
                b = s2.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException x) {
                throw new InternalError();
            }
            BsdVirtualMachine.write(fd, b, 0, b.length);
        }
        b = new byte[]{0};
        BsdVirtualMachine.write(fd, b, 0, 1);
    }

    static native void sendQuitTo(int var0) throws IOException;

    static native void checkPermissions(String var0) throws IOException;

    static native int socket() throws IOException;

    static native void connect(int var0, String var1) throws IOException;

    static native void close(int var0) throws IOException;

    static native int read(int var0, byte[] var1, int var2, int var3) throws IOException;

    static native void write(int var0, byte[] var1, int var2, int var3) throws IOException;

    static native void createAttachFile(String var0);

    static native String getTempDir();

    static {
        System.loadLibrary("attach");
        tmpdir = BsdVirtualMachine.getTempDir();
    }

    private class SocketInputStream
    extends InputStream {
        int s;

        public SocketInputStream(int s2) {
            this.s = s2;
        }

        @Override
        public synchronized int read() throws IOException {
            byte[] b = new byte[1];
            int n = this.read(b, 0, 1);
            if (n == 1) {
                return b[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public synchronized int read(byte[] bs, int off, int len) throws IOException {
            if (off < 0 || off > bs.length || len < 0 || off + len > bs.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            return BsdVirtualMachine.read(this.s, bs, off, len);
        }

        @Override
        public void close() throws IOException {
            BsdVirtualMachine.close(this.s);
        }
    }
}

