/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.v2_0;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.perfdata.monitor.AbstractPerfDataBufferPrologue;

public class PerfDataBufferPrologue
extends AbstractPerfDataBufferPrologue {
    private static final int SUPPORTED_MAJOR_VERSION = 2;
    private static final int SUPPORTED_MINOR_VERSION = 0;
    static final int PERFDATA_PROLOG_ACCESSIBLE_OFFSET = 7;
    static final int PERFDATA_PROLOG_ACCESSIBLE_SIZE = 1;
    static final int PERFDATA_PROLOG_USED_OFFSET = 8;
    static final int PERFDATA_PROLOG_USED_SIZE = 4;
    static final int PERFDATA_PROLOG_OVERFLOW_OFFSET = 12;
    static final int PERFDATA_PROLOG_OVERFLOW_SIZE = 4;
    static final int PERFDATA_PROLOG_MODTIMESTAMP_OFFSET = 16;
    static final int PERFDATA_PROLOG_MODTIMESTAMP_SIZE = 8;
    static final int PERFDATA_PROLOG_ENTRYOFFSET_OFFSET = 24;
    static final int PERFDATA_PROLOG_ENTRYOFFSET_SIZE = 4;
    static final int PERFDATA_PROLOG_NUMENTRIES_OFFSET = 28;
    static final int PERFDATA_PROLOG_NUMENTRIES_SIZE = 4;
    static final int PERFDATA_PROLOG_SIZE = 32;
    static final String PERFDATA_BUFFER_SIZE_NAME = "sun.perfdata.size";
    static final String PERFDATA_BUFFER_USED_NAME = "sun.perfdata.used";
    static final String PERFDATA_OVERFLOW_NAME = "sun.perfdata.overflow";
    static final String PERFDATA_MODTIMESTAMP_NAME = "sun.perfdata.timestamp";
    static final String PERFDATA_NUMENTRIES_NAME = "sun.perfdata.entries";

    public PerfDataBufferPrologue(ByteBuffer byteBuffer) throws MonitorException {
        super(byteBuffer);
        assert (this.getMajorVersion() == 2 && this.getMinorVersion() == 0);
    }

    @Override
    public boolean supportsAccessible() {
        return true;
    }

    @Override
    public boolean isAccessible() {
        assert (this.supportsAccessible());
        this.byteBuffer.position(7);
        byte value = this.byteBuffer.get();
        return value != 0;
    }

    public int getUsed() {
        this.byteBuffer.position(8);
        return this.byteBuffer.getInt();
    }

    public int getBufferSize() {
        return this.byteBuffer.capacity();
    }

    public int getOverflow() {
        this.byteBuffer.position(12);
        return this.byteBuffer.getInt();
    }

    public long getModificationTimeStamp() {
        this.byteBuffer.position(16);
        return this.byteBuffer.getLong();
    }

    public int getEntryOffset() {
        this.byteBuffer.position(24);
        return this.byteBuffer.getInt();
    }

    public int getNumEntries() {
        this.byteBuffer.position(28);
        return this.byteBuffer.getInt();
    }

    @Override
    public int getSize() {
        return 32;
    }

    IntBuffer usedBuffer() {
        this.byteBuffer.position(8);
        IntBuffer ib = this.byteBuffer.asIntBuffer();
        ib.limit(1);
        return ib;
    }

    IntBuffer sizeBuffer() {
        IntBuffer ib = IntBuffer.allocate(1);
        ib.put(this.byteBuffer.capacity());
        return ib;
    }

    IntBuffer overflowBuffer() {
        this.byteBuffer.position(12);
        IntBuffer ib = this.byteBuffer.asIntBuffer();
        ib.limit(1);
        return ib;
    }

    LongBuffer modificationTimeStampBuffer() {
        this.byteBuffer.position(16);
        LongBuffer lb = this.byteBuffer.asLongBuffer();
        lb.limit(1);
        return lb;
    }

    IntBuffer numEntriesBuffer() {
        this.byteBuffer.position(28);
        IntBuffer ib = this.byteBuffer.asIntBuffer();
        ib.limit(1);
        return ib;
    }
}

