/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.local;

import java.io.File;
import java.io.FilenameFilter;
import sun.misc.VMSupport;

public class PerfDataFile {
    public static final String tmpDirName;
    public static final String dirNamePrefix = "hsperfdata_";
    public static final String userDirNamePattern = "hsperfdata_\\S*";
    public static final String fileNamePattern = "^[0-9]+$";
    public static final String tmpFileNamePattern = "^hsperfdata_[0-9]+(_[1-2]+)?$";

    private PerfDataFile() {
    }

    public static File getFile(int lvmid) {
        if (lvmid == 0) {
            return null;
        }
        File tmpDir = new File(tmpDirName);
        String[] files = tmpDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!name.startsWith(PerfDataFile.dirNamePrefix)) {
                    return false;
                }
                File candidate = new File(dir, name);
                return (candidate.isDirectory() || candidate.isFile()) && candidate.canRead();
            }
        });
        long newestTime = 0L;
        File newest = null;
        for (int i = 0; i < files.length; ++i) {
            long modTime;
            File f = new File(tmpDirName + files[i]);
            File candidate = null;
            if (f.exists() && f.isDirectory()) {
                String name = Integer.toString(lvmid);
                candidate = new File(f.getName(), name);
            } else {
                candidate = f.exists() && f.isFile() ? f : f;
            }
            if (!candidate.exists() || !candidate.isFile() || !candidate.canRead() || (modTime = candidate.lastModified()) < newestTime) continue;
            newestTime = modTime;
            newest = candidate;
        }
        return newest;
    }

    public static File getFile(String user, int lvmid) {
        if (lvmid == 0) {
            return null;
        }
        String basename = PerfDataFile.getTempDirectory(user) + Integer.toString(lvmid);
        File f = new File(basename);
        if (f.exists() && f.isFile() && f.canRead()) {
            return f;
        }
        long newestTime = 0L;
        File newest = null;
        for (int i = 0; i < 2; ++i) {
            long modTime;
            basename = i == 0 ? PerfDataFile.getTempDirectory() + Integer.toString(lvmid) : PerfDataFile.getTempDirectory() + Integer.toString(lvmid) + Integer.toString(i);
            f = new File(basename);
            if (!f.exists() || !f.isFile() || !f.canRead() || (modTime = f.lastModified()) < newestTime) continue;
            newestTime = modTime;
            newest = f;
        }
        return newest;
    }

    public static int getLocalVmId(File file) {
        try {
            return Integer.parseInt(file.getName());
        }
        catch (NumberFormatException numberFormatException) {
            String name = file.getName();
            if (name.startsWith(dirNamePrefix)) {
                int first = name.indexOf(95);
                int last = name.lastIndexOf(95);
                try {
                    if (first == last) {
                        return Integer.parseInt(name.substring(first + 1));
                    }
                    return Integer.parseInt(name.substring(first + 1, last));
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("file name does not match pattern");
        }
    }

    public static String getTempDirectory() {
        return tmpDirName;
    }

    public static String getTempDirectory(String user) {
        return tmpDirName + dirNamePrefix + user + File.separator;
    }

    static {
        String tmpdir = VMSupport.getVMTemporaryDirectory();
        if (tmpdir.lastIndexOf(File.separator) != tmpdir.length() - 1) {
            tmpdir = tmpdir + File.separator;
        }
        tmpDirName = tmpdir;
    }
}

