/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.local;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.jvmstat.perfdata.monitor.protocol.local.PerfDataFile;

public class LocalVmManager {
    private String userName;
    private File tmpdir;
    private Pattern userPattern;
    private Matcher userMatcher;
    private FilenameFilter userFilter;
    private Pattern filePattern;
    private Matcher fileMatcher;
    private FilenameFilter fileFilter;
    private Pattern tmpFilePattern;
    private Matcher tmpFileMatcher;
    private FilenameFilter tmpFileFilter;

    public LocalVmManager() {
        this(null);
    }

    public LocalVmManager(String user) {
        this.userName = user;
        if (this.userName == null) {
            this.tmpdir = new File(PerfDataFile.getTempDirectory());
            this.userPattern = Pattern.compile("hsperfdata_\\S*");
            this.userMatcher = this.userPattern.matcher("");
            this.userFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    LocalVmManager.this.userMatcher.reset(name);
                    return LocalVmManager.this.userMatcher.lookingAt();
                }
            };
        } else {
            this.tmpdir = new File(PerfDataFile.getTempDirectory(this.userName));
        }
        this.filePattern = Pattern.compile("^[0-9]+$");
        this.fileMatcher = this.filePattern.matcher("");
        this.fileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                LocalVmManager.this.fileMatcher.reset(name);
                return LocalVmManager.this.fileMatcher.matches();
            }
        };
        this.tmpFilePattern = Pattern.compile("^hsperfdata_[0-9]+(_[1-2]+)?$");
        this.tmpFileMatcher = this.tmpFilePattern.matcher("");
        this.tmpFileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                LocalVmManager.this.tmpFileMatcher.reset(name);
                return LocalVmManager.this.tmpFileMatcher.matches();
            }
        };
    }

    public synchronized Set<Integer> activeVms() {
        int j;
        File[] files;
        HashSet<Integer> jvmSet = new HashSet<Integer>();
        if (!this.tmpdir.isDirectory()) {
            return jvmSet;
        }
        if (this.userName == null) {
            File[] dirs = this.tmpdir.listFiles(this.userFilter);
            for (int i = 0; i < dirs.length; ++i) {
                File[] files2;
                if (!dirs[i].isDirectory() || (files2 = dirs[i].listFiles(this.fileFilter)) == null) continue;
                for (int j2 = 0; j2 < files2.length; ++j2) {
                    if (!files2[j2].isFile() || !files2[j2].canRead()) continue;
                    jvmSet.add(new Integer(PerfDataFile.getLocalVmId(files2[j2])));
                }
            }
        } else {
            files = this.tmpdir.listFiles(this.fileFilter);
            if (files != null) {
                for (j = 0; j < files.length; ++j) {
                    if (!files[j].isFile() || !files[j].canRead()) continue;
                    jvmSet.add(new Integer(PerfDataFile.getLocalVmId(files[j])));
                }
            }
        }
        if ((files = this.tmpdir.listFiles(this.tmpFileFilter)) != null) {
            for (j = 0; j < files.length; ++j) {
                if (!files[j].isFile() || !files[j].canRead()) continue;
                jvmSet.add(new Integer(PerfDataFile.getLocalVmId(files[j])));
            }
        }
        return jvmSet;
    }
}

