/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.term;

import io.termd.core.term.ElsePart;
import io.termd.core.term.EvalContext;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class OpCode {
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public void eval(EvalContext context) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " operation not implemented");
    }

    protected abstract void toString(StringBuilder var1);

    public static class Then
    extends OpCode {
        final List<OpCode> expr;
        final ElsePart elsePart;

        public Then(List<OpCode> expr, ElsePart elsePart) {
            this.expr = expr;
            this.elsePart = elsePart;
        }

        public Then(List<OpCode> expr) {
            this.expr = expr;
            this.elsePart = null;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Then) {
                Then that = (Then)obj;
                return this.expr.equals(that.expr) && (this.elsePart == null ? that.elsePart == null : this.elsePart.equals(that.elsePart));
            }
            return false;
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append("%t");
            for (OpCode op : this.expr) {
                op.toString(sb);
            }
            if (this.elsePart instanceof Else) {
                ((Else)this.elsePart).toString(sb);
            } else if (this.elsePart instanceof If) {
                ((If)this.elsePart).toString(sb);
            }
        }

        @Override
        public void eval(EvalContext context) {
            int cond = Integer.parseInt(context.pop());
            if (cond != 0) {
                for (OpCode opCode : this.expr) {
                    opCode.eval(context);
                }
            } else if (this.elsePart instanceof If) {
                ((If)this.elsePart).eval(context);
            } else if (this.elsePart instanceof Else) {
                ((Else)this.elsePart).eval(context);
            }
        }
    }

    public static class Else
    extends OpCode
    implements ElsePart {
        final List<OpCode> expr;

        public Else(List<OpCode> expr) {
            this.expr = expr;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Else) {
                Else that = (Else)obj;
                return this.expr.equals(that.expr);
            }
            return false;
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append("%e");
            for (OpCode op : this.expr) {
                op.toString(sb);
            }
        }

        @Override
        public void eval(EvalContext context) {
            for (OpCode opCode : this.expr) {
                opCode.eval(context);
            }
        }
    }

    public static class If
    extends OpCode
    implements ElsePart {
        final List<OpCode> expr;
        final Then thenPart;

        public If(List<OpCode> expr, Then thenPart) {
            this.expr = expr;
            this.thenPart = thenPart;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof If) {
                If that = (If)obj;
                return this.expr.equals(that.expr) && this.thenPart.equals(that.thenPart);
            }
            return false;
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append("%?");
            for (OpCode op : this.expr) {
                op.toString(sb);
            }
            this.thenPart.toString(sb);
            sb.append("%;");
        }

        @Override
        public void eval(EvalContext context) {
            for (OpCode opCode : this.expr) {
                opCode.eval(context);
            }
            this.thenPart.eval(context);
        }
    }

    public static class Printf
    extends OpCode {
        private static final Pattern p = Pattern.compile("%:?([-+# ])?([0-9]+)?(?:\\.([0-9]+))?([doxXs])?");
        private final Character flag;
        private final String width;
        private final String precision;
        private final Character specifier;

        public static Printf parse(String s2) {
            Matcher m3 = p.matcher(s2);
            if (!m3.matches()) {
                throw new IllegalArgumentException("Invalid printf pattern " + s2);
            }
            String flag = m3.group(1);
            String width = m3.group(2);
            String precision = m3.group(3);
            String specifier = m3.group(4);
            return new Printf(flag != null ? Character.valueOf(flag.charAt(0)) : null, width, precision, specifier != null ? Character.valueOf(specifier.charAt(0)) : null);
        }

        public Printf(Character flag, String width, String precision, Character specifier) {
            this.flag = flag;
            this.width = width;
            this.precision = precision;
            this.specifier = specifier;
        }

        public Character getFlag() {
            return this.flag;
        }

        public String getWidth() {
            return this.width;
        }

        public String getPrecision() {
            return this.precision;
        }

        public Character getSpecifier() {
            return this.specifier;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Printf) {
                Printf that = (Printf)obj;
                return (this.flag == null ? that.flag == null : this.flag.equals(that.flag)) && (this.width == null ? that.width == null : this.width.equals(that.width)) && (this.precision == null ? that.precision == null : this.precision.equals(that.precision)) && (this.specifier == null ? that.specifier == null : this.specifier.equals(that.specifier));
            }
            return false;
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append("%:");
            if (this.flag != null) {
                sb.append(this.flag);
            }
            if (this.width != null) {
                sb.append(this.width);
            }
            if (this.precision != null) {
                sb.append(".").append(this.precision);
            }
            if (this.specifier != null) {
                sb.append(this.specifier);
            }
        }

        @Override
        public void eval(EvalContext context) {
            if (this.flag != null || this.width != null || this.precision != null) {
                super.eval(context);
            }
            if (this.specifier != null) {
                switch (this.specifier.charValue()) {
                    case 'd': {
                        int value = Integer.parseInt(context.pop());
                        context.writeNumber(value);
                        break;
                    }
                    case 's': {
                        String s2 = context.pop();
                        context.writeString(s2);
                        break;
                    }
                    default: {
                        super.eval(context);
                    }
                }
            }
        }
    }

    public static class Arithmetic
    extends OpCode {
        public static final Arithmetic PLUS = new Arithmetic('+'){

            @Override
            public void eval(EvalContext context) {
                int op1 = Integer.parseInt(context.pop());
                int op2 = Integer.parseInt(context.pop());
                context.push(Integer.toString(op1 + op2));
            }
        };
        public static final Arithmetic MINUS = new Arithmetic('-');
        public static final Arithmetic MUL = new Arithmetic('*');
        public static final Arithmetic DIV = new Arithmetic('/');
        public static final Arithmetic MOD = new Arithmetic('m');
        final char value;

        private Arithmetic(char value) {
            this.value = value;
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append('%').append(this.value);
        }
    }

    public static class Logical
    extends OpCode {
        public static final Logical EQ = new Logical('='){

            @Override
            public void eval(EvalContext context) {
                int op2;
                int op1 = Integer.parseInt(context.pop());
                context.push(op1 == (op2 = Integer.parseInt(context.pop())) ? "1" : "0");
            }
        };
        public static final Logical GT = new Logical('>');
        public static final Logical LT = new Logical('<');
        public static final Logical AND = new Logical('A');
        public static final Logical OR = new Logical('O');
        public static final Logical NEG = new Logical('!');
        final char value;

        private Logical(char value) {
            this.value = value;
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append('%').append(this.value);
        }
    }

    public static class Bit
    extends OpCode {
        public static final Bit OR = new Bit('|');
        public static final Bit AND = new Bit('&');
        public static final Bit XOR = new Bit('^');
        public static final Bit NEG = new Bit('~');
        private final char value;

        private Bit(char value) {
            this.value = value;
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append('%').append(this.value);
        }
    }

    public static class GetPushVar
    extends OpCode {
        private final char value;

        public GetPushVar(char value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof GetPushVar) {
                GetPushVar that = (GetPushVar)obj;
                return this.value == that.value;
            }
            return false;
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append("%g").append(this.value);
        }
    }

    public static class SetPopVar
    extends OpCode {
        private final char value;

        public SetPopVar(char value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SetPopVar) {
                SetPopVar that = (SetPopVar)obj;
                return this.value == that.value;
            }
            return false;
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append("%P").append(this.value);
        }
    }

    public static class PrintChar
    extends OpCode {
        public static final PrintChar INSTANCE = new PrintChar();

        private PrintChar() {
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append("%c");
        }

        @Override
        public void eval(EvalContext context) {
            String s2 = context.pop();
            int codePoint = Integer.parseInt(s2);
            context.writeCodePoint(codePoint);
        }
    }

    public static class Add1ToParams
    extends OpCode {
        public static final Add1ToParams INSTANCE = new Add1ToParams();

        private Add1ToParams() {
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append("%i");
        }

        @Override
        public void eval(EvalContext context) {
            if (context.getParametersLength() < 2) {
                throw new IllegalArgumentException("Missing parameters");
            }
            for (int i = 0; i < 2; ++i) {
                context.setParameter(i, Integer.toString(Integer.parseInt(context.getParameter(i)) + 1));
            }
        }
    }

    public static class PushStrLen
    extends OpCode {
        public static final PushStrLen INSTANCE = new PushStrLen();

        private PushStrLen() {
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append("%l");
        }
    }

    public static class Percent
    extends OpCode {
        public static final Percent INSTANCE = new Percent();

        private Percent() {
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append("%%");
        }
    }

    public static class PushConstant
    extends OpCode {
        private final int value;
        private final boolean literal;

        public PushConstant(int value, boolean literal) {
            this.value = value;
            this.literal = literal;
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PushConstant) {
                PushConstant that = (PushConstant)obj;
                return this.value == that.value && this.literal == that.literal;
            }
            return false;
        }

        @Override
        protected void toString(StringBuilder sb) {
            if (this.literal) {
                sb.append("%{").append(this.value).append("}");
            } else {
                sb.append("%'").append((char)this.value).append("'");
            }
        }

        @Override
        public void eval(EvalContext context) {
            StringBuilder sb = new StringBuilder();
            if (this.literal) {
                sb.append(this.value);
            } else {
                sb.appendCodePoint(this.value);
            }
            context.push(sb.toString());
        }
    }

    public static class Literal
    extends OpCode {
        final String value;

        public Literal(String value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Literal) {
                Literal that = (Literal)obj;
                return this.value.equals(that.value);
            }
            return false;
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append(this.value);
        }

        @Override
        public void eval(EvalContext context) {
            context.writeString(this.value);
        }
    }

    public static class PushParam
    extends OpCode {
        private final int index;

        public PushParam(int index) {
            if (index < 1 || index > 9) {
                throw new IllegalArgumentException("Parameter index must be between 1 and 9");
            }
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PushParam) {
                PushParam that = (PushParam)obj;
                return this.index == that.index;
            }
            return false;
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append("%p").append(this.index);
        }

        @Override
        public void eval(EvalContext context) {
            int ptr = this.index - 1;
            if (ptr >= context.getParametersLength()) {
                throw new IllegalArgumentException("Not enough parameters");
            }
            context.push(context.getParameter(ptr));
        }
    }
}

