/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.pty;

import io.termd.core.function.BiConsumer;
import io.termd.core.function.Consumer;
import io.termd.core.pty.PtyMaster;
import io.termd.core.readline.Function;
import io.termd.core.readline.Keymap;
import io.termd.core.readline.Readline;
import io.termd.core.tty.TtyConnection;
import io.termd.core.tty.TtyEvent;
import io.termd.core.util.Helper;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TtyBridge {
    Logger log = LoggerFactory.getLogger(TtyBridge.class);
    final TtyConnection conn;
    private Consumer<PtyMaster> processListener;
    private Consumer<int[]> processStdoutListener;
    private Consumer<String> processStdinListener;

    public TtyBridge(TtyConnection conn) {
        this.conn = conn;
    }

    public Consumer<PtyMaster> getProcessListener() {
        return this.processListener;
    }

    public TtyBridge setProcessListener(Consumer<PtyMaster> processListener) {
        this.processListener = processListener;
        return this;
    }

    public Consumer<String> getProcessStdinListener() {
        return this.processStdinListener;
    }

    public TtyBridge setProcessStdinListener(Consumer<String> processStdinListener) {
        this.processStdinListener = processStdinListener;
        return this;
    }

    public Consumer<int[]> getProcessStdoutListener() {
        return this.processStdoutListener;
    }

    public TtyBridge setProcessStdoutListener(Consumer<int[]> processStdoutListener) {
        this.processStdoutListener = processStdoutListener;
        return this;
    }

    public TtyBridge readline() {
        InputStream inputrc = Keymap.class.getResourceAsStream("inputrc");
        Keymap keymap = new Keymap(inputrc);
        Readline readline = new Readline(keymap);
        for (Function function : Helper.loadServices(Thread.currentThread().getContextClassLoader(), Function.class)) {
            this.log.trace("Server is adding function to readline: {}", (Object)function);
            readline.addFunction(function);
        }
        this.conn.setTerminalTypeHandler(new Consumer<String>(){

            @Override
            public void accept(String s2) {
            }
        });
        this.conn.stdoutHandler().accept(Helper.toCodePoints("Welcome sir\n"));
        this.read(this.conn, readline);
        return this;
    }

    void read(final TtyConnection conn, final Readline readline) {
        readline.readline(conn, "% ", new Consumer<String>(){

            @Override
            public void accept(String line) {
                if (TtyBridge.this.processStdinListener != null) {
                    TtyBridge.this.processStdinListener.accept(line);
                }
                if (line == null) {
                    conn.close();
                    return;
                }
                final PtyMaster task = new PtyMaster(line, new Consumer<int[]>(){

                    @Override
                    public void accept(final int[] buffer) {
                        conn.execute(new Runnable(){

                            @Override
                            public void run() {
                                conn.stdoutHandler().accept(buffer);
                            }
                        });
                    }
                }, new Consumer<Void>(){

                    @Override
                    public void accept(Void v) {
                        conn.setEventHandler(null);
                        conn.execute(new Runnable(){

                            @Override
                            public void run() {
                                TtyBridge.this.read(conn, readline);
                            }
                        });
                    }
                });
                conn.setEventHandler(new BiConsumer<TtyEvent, Integer>(){

                    @Override
                    public void accept(TtyEvent event, Integer integer) {
                        if (event == TtyEvent.INTR) {
                            task.interruptProcess();
                        }
                    }
                });
                if (TtyBridge.this.processListener != null) {
                    TtyBridge.this.processListener.accept(task);
                }
                task.start();
            }
        });
    }
}

