/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.wrapped.com.sun.tools.attach;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachOperationFailedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Provider
extends AttachProvider {
    private static final String SYSTEM_PROPERTY_OS_NAME = "os.name";
    private volatile AttachProvider provider;

    private static Optional<AttachProvider> findProvider() {
        HashMap<String, AttachProvider> map = new HashMap<String, AttachProvider>();
        Provider.put(map, "windows", "sun.tools.attach.WindowsAttachProvider");
        Provider.put(map, "mac os x", "sun.tools.attach.BsdAttachProvider");
        Provider.put(map, "bsd", "sun.tools.attach.BsdAttachProvider");
        Provider.put(map, "sunos", "sun.tools.attach.SolarisAttachProvider");
        Provider.put(map, "solaris", "sun.tools.attach.SolarisAttachProvider");
        Provider.put(map, "linux", "sun.tools.attach.LinuxAttachProvider");
        if (map.isEmpty()) {
            Provider.put(map, Provider.os(), "sun.tools.attach.AttachProviderImpl");
        }
        return map.entrySet().stream().filter(e -> Provider.os().startsWith((String)e.getKey())).map(Map.Entry::getValue).findFirst();
    }

    private static void put(Map<String, AttachProvider> map, String os, String attachProviderClass) {
        try {
            Class<?> type = Provider.class.getClassLoader().loadClass(attachProviderClass);
            map.put(os, (AttachProvider)type.newInstance());
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            Provider.swallow(e);
        }
    }

    private static void swallow(Exception gulp) {
    }

    private static String os() {
        return System.getProperty(SYSTEM_PROPERTY_OS_NAME, "").toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AttachProvider provider() {
        if (this.provider != null) return this.provider;
        Class<Provider> clazz = Provider.class;
        synchronized (Provider.class) {
            if (this.provider != null) return this.provider;
            this.provider = Provider.findProvider().orElseThrow(Provider::providerNotFound);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.provider;
        }
    }

    private static UncheckedIOException providerNotFound() {
        return new UncheckedIOException(new AttachOperationFailedException("Failed to locate AttachProvider for this OS: " + Provider.os()));
    }

    @Override
    public VirtualMachine attachVirtualMachine(String arg0) throws AttachNotSupportedException, IOException {
        return this.provider().attachVirtualMachine(arg0);
    }

    @Override
    public List<VirtualMachineDescriptor> listVirtualMachines() {
        return this.provider().listVirtualMachines();
    }

    @Override
    public String name() {
        return this.provider().name();
    }

    @Override
    public String type() {
        return this.provider().type();
    }
}

